/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface represents the basis for all basic map mapping types defined by the EclipseLink
 * JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalBasicMapMapping extends ExternalBasicCollectionMapping {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String BASIC_MAP = "basic-map";

	/**
	 * The attribute name used to store and retrieve the fetch property.
	 */
	String FETCH = "fetch";

	/**
	 * The element name used to store and retrieve the join-fetch child text node.
	 */
	String JOIN_FETCH = "join-fetch";

	/**
	 * The element name used to store and retrieve the key-column child node.
	 */
	String KEY_COLUMN = "key-column";

	/**
	 * The element name used to store and retrieve the key-converter child text node.
	 */
	String KEY_CONVERTER = "key-converter";

	/**
	 * The element name used to store and retrieve the value-column child node.
	 */
	String VALUE_COLUMN = "value-column";

	/**
	 * The element name used to store and retrieve the value-converter child text node.
	 */
	String VALUE_CONVERTER = "value-converter";

	/**
	 * Visits this {@link ExternalBasicMapMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Adds the key column for this mapping.
	 */
	ExternalEntityColumn addKeyColumn(String columnName);

	/**
	 * Adds the key converter string to the mapping.
	 */
	void addKeyConverterString(String converter);

	/**
	 * Returns the key column for this mapping.
	 */
	ExternalEntityColumn getKeyColumn();

	/**
	 * Returns the key converter for this mapping.
	 */
	ExternalClassConverter getKeyConverter();

	/**
	 * Returns the {@link TextRange} for the key converter string.
	 */
	TextRange getKeyConveterTextRange();

	/**
	 * Returns the key object type converter for this mapping.
	 */
	ExternalObjectTypeConverter getKeyObjectTypeConverter();

	/**
	 * Returns the key struct converter for this mapping.
	 */
	ExternalStructConverter getKeyStructConverter();

	/**
	 * Returns the key type converter for this mapping.
	 */
	ExternalTypeConverter getKeyTypeConverter();

	/**
	 * Removes the key column from this mapping.
	 */
	void removeKeyColumn();

	/**
	 * Removes the key converter from mapping.
	 */
	void removeKeyConverter();

	/**
	 * Removes the key converter String.
	 */
	void removeKeyConverterString();

	/**
	 * Removes the key object type converter from mapping.
	 */
	void removeKeyObjectTypeConverter();

	/**
	 * Removes the key struct converter from mapping.
	 */
	void removeKeyStructConverter();

	/**
	 * Removes the key type converter from mapping.
	 */
	void removeKeyTypeConverter();

	/**
	 * Sets the mapping to use this converter for its key converter.
	 */
	void setAsKeyConverter(String name, String className);

	/**
	 * Sets the mapping to use this object type converter for its key converter.
	 */
	void setAsKeyObjectTypeConverter(String name);

	/**
	 * Sets the mapping to use this struct converter for its key converter.
	 */
	void setAsKeyStructConverter(String name, String converter);

	/**
	 * Sets the mapping to use this type converter for its key converter.
	 */
	void setAsKeyTypeConverter(String name);

	/**
	 * Sets the key converter string value.
	 */
	void setKeyConverter(String value);
}