/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyIterator;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;
import org.eclipse.persistence.tools.utility.model.value.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.utility.model.value.CollectionAspectAdapter;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.NullListValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyAspectAdapter;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.SortedListValueModelWrapper;
import org.eclipse.persistence.tools.utility.model.value.StaticPropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.TransformationListValueModel;
import org.eclipse.persistence.tools.utility.model.value.TreeNodeValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.utility.tests.model.Displayable;

public class TreeModelAdapterTests
extends TestCase {
    boolean eventFired;

    public TreeModelAdapterTests(String name) {
        super(name);
    }

    public void testGetRoot() {
        TreeModel treeModel = this.buildSortedTreeModel();
        treeModel.addTreeModelListener(new TestTreeModelListener());
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TestModel root = rootNode.getTestModel();
        TreeModelAdapterTests.assertEquals((String)"root", (String)root.getName());
    }

    public void testGetChild() {
        TreeModel treeModel = this.buildSortedTreeModel();
        treeModel.addTreeModelListener(new TestTreeModelListener());
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TestNode expected = rootNode.childNamed("node 1");
        TestNode actual = (TestNode)treeModel.getChild(rootNode, 1);
        TreeModelAdapterTests.assertEquals((Object)expected, (Object)actual);
        expected = rootNode.childNamed("node 2");
        actual = (TestNode)treeModel.getChild(rootNode, 2);
        TreeModelAdapterTests.assertEquals((Object)expected, (Object)actual);
    }

    public void testGetChildCount() {
        TreeModel treeModel = this.buildSortedTreeModel();
        treeModel.addTreeModelListener(new TestTreeModelListener());
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TreeModelAdapterTests.assertEquals((int)5, (int)treeModel.getChildCount(rootNode));
        TestNode node = rootNode.childNamed("node 1");
        TreeModelAdapterTests.assertEquals((int)1, (int)treeModel.getChildCount(node));
    }

    public void testGetIndexOfChild() {
        TreeModel treeModel = this.buildSortedTreeModel();
        treeModel.addTreeModelListener(new TestTreeModelListener());
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TestNode child = rootNode.childNamed("node 0");
        TreeModelAdapterTests.assertEquals((int)0, (int)treeModel.getIndexOfChild(rootNode, child));
        child = rootNode.childNamed("node 1");
        TreeModelAdapterTests.assertEquals((int)1, (int)treeModel.getIndexOfChild(rootNode, child));
        child = rootNode.childNamed("node 2");
        TreeModelAdapterTests.assertEquals((int)2, (int)treeModel.getIndexOfChild(rootNode, child));
        TestNode grandchild = child.childNamed("node 2.2");
        TreeModelAdapterTests.assertEquals((int)2, (int)treeModel.getIndexOfChild(child, grandchild));
    }

    public void testIsLeaf() {
        TreeModel treeModel = this.buildSortedTreeModel();
        treeModel.addTreeModelListener(new TestTreeModelListener());
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TreeModelAdapterTests.assertFalse((boolean)treeModel.isLeaf(rootNode));
        TestNode node = rootNode.childNamed("node 1");
        TreeModelAdapterTests.assertFalse((boolean)treeModel.isLeaf(node));
        node = rootNode.childNamed("node 3");
        TreeModelAdapterTests.assertTrue((boolean)treeModel.isLeaf(node));
    }

    public void testTreeNodesChanged() {
        TreeModel treeModel = this.buildUnsortedTreeModel();
        this.eventFired = false;
        treeModel.addTreeModelListener(new TestTreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TreeModelAdapterTests.this.eventFired = true;
            }
        });
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TestNode node = rootNode.childNamed("node 1");
        TestModel tm = node.getTestModel();
        tm.setName("node 1++");
        TreeModelAdapterTests.assertTrue((boolean)this.eventFired);
        this.eventFired = false;
        node = node.childNamed("node 1.1");
        tm = node.getTestModel();
        tm.setName("node 1.1++");
        TreeModelAdapterTests.assertTrue((boolean)this.eventFired);
    }

    public void testTreeNodesInserted() {
        TreeModel treeModel = this.buildUnsortedTreeModel();
        this.eventFired = false;
        treeModel.addTreeModelListener(new TestTreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeModelAdapterTests.this.eventFired = true;
            }
        });
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TestNode node = rootNode.childNamed("node 1");
        TestModel tm = node.getTestModel();
        tm.addChild("new child...");
        TreeModelAdapterTests.assertTrue((boolean)this.eventFired);
        this.eventFired = false;
        node = node.childNamed("node 1.1");
        tm = node.getTestModel();
        tm.addChild("another new child...");
        TreeModelAdapterTests.assertTrue((boolean)this.eventFired);
    }

    public void testTreeNodesRemoved() {
        TreeModel treeModel = this.buildUnsortedTreeModel();
        this.eventFired = false;
        treeModel.addTreeModelListener(new TestTreeModelListener(){

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TreeModelAdapterTests.this.eventFired = true;
            }
        });
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TestModel root = rootNode.getTestModel();
        root.removeChild(root.childNamed("node 3"));
        TreeModelAdapterTests.assertTrue((boolean)this.eventFired);
        this.eventFired = false;
        TestNode node = rootNode.childNamed("node 2");
        TestModel tm = node.getTestModel();
        tm.removeChild(tm.childNamed("node 2.2"));
        TreeModelAdapterTests.assertTrue((boolean)this.eventFired);
    }

    public void testTreeStructureChanged() {
        SimplePropertyValueModel nodeHolder = new SimplePropertyValueModel((Object)this.buildSortedRootNode());
        TreeModel treeModel = this.buildTreeModel((PropertyValueModel<TreeNodeValueModel<Object>>)nodeHolder);
        this.eventFired = false;
        treeModel.addTreeModelListener(new TestTreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TreeModelAdapterTests.this.eventFired = true;
            }
        });
        nodeHolder.setValue((Object)this.buildUnsortedRootNode());
        TreeModelAdapterTests.assertTrue((boolean)this.eventFired);
    }

    public void testLazyInitialization() {
        TreeModel treeModel = this.buildSpecialTreeModel();
        JTree jTree = new JTree(treeModel);
        TestNode rootNode = (TestNode)treeModel.getRoot();
        TestModel root = rootNode.getTestModel();
        root.removeChild(root.childNamed("node 3"));
        TreeModelAdapterTests.assertEquals((Object)treeModel, (Object)jTree.getModel());
    }

    private TreeModel buildSortedTreeModel() {
        return this.buildTreeModel(this.buildSortedRootNode());
    }

    private TestNode buildSortedRootNode() {
        return new SortedTestNode(this.buildRoot());
    }

    private TreeModel buildUnsortedTreeModel() {
        return this.buildTreeModel(this.buildUnsortedRootNode());
    }

    private TestNode buildUnsortedRootNode() {
        return new UnsortedTestNode(this.buildRoot());
    }

    private TreeModel buildSpecialTreeModel() {
        return this.buildTreeModel(this.buildSpecialRootNode());
    }

    private TestNode buildSpecialRootNode() {
        return new SpecialTestNode(this.buildRoot());
    }

    private TestModel buildRoot() {
        TestModel root = new TestModel("root");
        root.addChild("node 0");
        TestModel node_1 = root.addChild("node 1");
        TestModel node_1_1 = node_1.addChild("node 1.1");
        node_1_1.addChild("node 1.1.1");
        TestModel node_2 = root.addChild("node 2");
        node_2.addChild("node 2.0");
        node_2.addChild("node 2.1");
        node_2.addChild("node 2.2");
        node_2.addChild("node 2.3");
        node_2.addChild("node 2.4");
        node_2.addChild("node 2.5");
        root.addChild("node 3");
        root.addChild("node 4");
        return root;
    }

    private TreeModel buildTreeModel(TestNode root) {
        return this.buildTreeModel((PropertyValueModel<TreeNodeValueModel<Object>>)new StaticPropertyValueModel((Object)root));
    }

    private TreeModel buildTreeModel(PropertyValueModel<TreeNodeValueModel<Object>> rootHolder) {
        return new TreeModelAdapter<Object>(rootHolder){

            protected ListChangeListener buildChildrenListener() {
                return this.buildChildrenListener_();
            }

            protected StateChangeListener buildNodeStateListener() {
                return this.buildNodeStateListener_();
            }

            protected PropertyChangeListener buildNodeValueListener() {
                return this.buildNodeValueListener_();
            }

            protected PropertyChangeListener buildRootListener() {
                return this.buildRootListener_();
            }
        };
    }

    public static class NameTestNode
    extends AbstractTreeNodeValueModel<Object> {
        private final ModifiablePropertyValueModel<String> nameAdapter;
        private final SpecialTestNode specialNode;
        private final PropertyChangeListener nameListener = this.buildNameListener();
        private final ListValueModel<TreeNodeValueModel<Object>> childrenModel;

        public NameTestNode(SpecialTestNode specialNode) {
            this.specialNode = specialNode;
            this.nameAdapter = this.buildNameAdapter();
            this.childrenModel = new NullListValueModel();
        }

        protected PropertyChangeListener buildNameListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent e) {
                    NameTestNode.this.nameChanged(e);
                }
            };
        }

        protected ModifiablePropertyValueModel<String> buildNameAdapter() {
            return new PropertyAspectAdapter<TestModel, String>("name", this.getTestModel()){

                protected String buildValue_() {
                    return ((TestModel)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((TestModel)((Object)this.subject)).setName(value);
                }
            };
        }

        public TestModel getTestModel() {
            return this.specialNode.getTestModel();
        }

        public String getValue() {
            return (String)this.nameAdapter.getValue();
        }

        public void setValue(Object value) {
            this.nameAdapter.setValue((Object)((String)value));
        }

        public TreeNodeValueModel<Object> parent() {
            return this.specialNode;
        }

        public ListValueModel<TreeNodeValueModel<Object>> childrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
            this.nameAdapter.addPropertyChangeListener("value", this.nameListener);
        }

        protected void disengageValue() {
            this.nameAdapter.removePropertyChangeListener("value", this.nameListener);
        }

        protected void nameChanged(PropertyChangeEvent e) {
            this.firePropertyChanged("value", e.getOldValue(), e.getNewValue());
        }
    }

    public static class SortedTestNode
    extends TestNode {
        public SortedTestNode(TestModel testModel) {
            super(testModel);
        }

        public SortedTestNode(TestNode parent, TestModel testModel) {
            super(parent, testModel);
        }

        @Override
        protected ListValueModel<TreeNodeValueModel<Object>> buildChildrenModel(TestModel testModel) {
            return new SortedListValueModelWrapper(this.buildDisplayStringAdapter(testModel));
        }

        protected ListValueModel<TreeNodeValueModel<Object>> buildDisplayStringAdapter(TestModel testModel) {
            return new ItemPropertyListValueModelAdapter(this.buildNodeAdapter(testModel), new String[]{"displayString"});
        }

        @Override
        protected TestNode buildChildNode(TestModel childNode) {
            return new SortedTestNode(this, childNode);
        }
    }

    public static class SpecialTestNode
    extends UnsortedTestNode {
        public SpecialTestNode(TestModel testModel) {
            super(testModel);
        }

        public SpecialTestNode(TestNode parent, TestModel testModel) {
            super(parent, testModel);
        }

        @Override
        protected ListValueModel<TreeNodeValueModel<Object>> buildChildrenModel(TestModel testModel) {
            if (testModel.getName().equals("node 3")) {
                return this.buildSpecialChildrenModel();
            }
            return super.buildChildrenModel(testModel);
        }

        protected ListValueModel<TreeNodeValueModel<Object>> buildSpecialChildrenModel() {
            NameTestNode[] children = new NameTestNode[]{new NameTestNode(this)};
            return new SimpleListValueModel(Arrays.asList(children));
        }

        @Override
        protected TestNode buildChildNode(TestModel childNode) {
            return new SpecialTestNode(this, childNode);
        }
    }

    public static class TestModel
    extends AbstractModel {
        private final TestModel parent;
        private String name;
        public static final String NAME_PROPERTY = "name";
        private final Collection<TestModel> children;
        public static final String CHILDREN_COLLECTION = "children";

        public TestModel(String name) {
            this(null, name);
        }

        private TestModel(TestModel parent, String name) {
            this.parent = parent;
            this.name = name;
            this.children = new HashBag();
        }

        public TestModel getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public Iterator<TestModel> children() {
            return new ReadOnlyIterator(this.children);
        }

        public int childrenSize() {
            return this.children.size();
        }

        public TestModel addChild(String childName) {
            TestModel child = new TestModel(this, childName);
            this.addItemToCollection((Object)child, this.children, CHILDREN_COLLECTION);
            return child;
        }

        public TestModel[] addChildren(String[] childNames) {
            TestModel[] newChildren = new TestModel[childNames.length];
            int i = 0;
            while (i < childNames.length) {
                newChildren[i] = new TestModel(this, childNames[i]);
                ++i;
            }
            this.addItemsToCollection((Object[])newChildren, this.children, CHILDREN_COLLECTION);
            return newChildren;
        }

        public void removeChild(TestModel child) {
            this.removeItemFromCollection((Object)child, this.children, CHILDREN_COLLECTION);
        }

        public void removeChildren(TestModel[] testModels) {
            this.removeItemsFromCollection((Object[])testModels, this.children, CHILDREN_COLLECTION);
        }

        public void clearChildren() {
            this.clearCollection(this.children, CHILDREN_COLLECTION);
        }

        public TestModel childNamed(String childName) {
            for (TestModel child : this.children) {
                if (!child.getName().equals(childName)) continue;
                return child;
            }
            throw new RuntimeException("child not found: " + childName);
        }

        public String dumpString() {
            StringWriter sw = new StringWriter();
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)sw);
            this.dumpOn(ipw);
            return sw.toString();
        }

        public void dumpOn(IndentingPrintWriter writer) {
            writer.println((Object)this);
            writer.indent();
            for (TestModel child : this.children) {
                child.dumpOn(writer);
            }
            writer.undent();
        }

        public void dumpOn(OutputStream stream) {
            IndentingPrintWriter writer = new IndentingPrintWriter((Writer)new OutputStreamWriter(stream));
            this.dumpOn(writer);
            writer.flush();
        }

        public void dump() {
            this.dumpOn(System.out);
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this), (String)this.name);
        }
    }

    public static abstract class TestNode
    extends AbstractTreeNodeValueModel<Object>
    implements Displayable,
    Comparable<TestNode> {
        private final TestModel testModel;
        private final TestNode parent;
        private final ListValueModel<TreeNodeValueModel<Object>> childrenModel;
        private final PropertyChangeListener testModelListener;

        public TestNode(TestModel testModel) {
            this(null, testModel);
        }

        public TestNode(TestNode parent, TestModel testModel) {
            this.parent = parent;
            this.testModel = testModel;
            this.childrenModel = this.buildChildrenModel(testModel);
            this.testModelListener = this.buildTestModelListener();
        }

        private PropertyChangeListener buildTestModelListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent e) {
                    TestNode.this.testModelChanged(e);
                }
            };
        }

        protected abstract ListValueModel<TreeNodeValueModel<Object>> buildChildrenModel(TestModel var1);

        protected ListValueModel<TreeNodeValueModel<Object>> buildNodeAdapter(TestModel model) {
            return new TransformationListValueModel<TestModel, TreeNodeValueModel<Object>>(this.buildChildrenAdapter(model)){

                protected TestNode transformItem(TestModel item) {
                    return TestNode.this.buildChildNode(item);
                }
            };
        }

        protected abstract TestNode buildChildNode(TestModel var1);

        protected CollectionValueModel<TestModel> buildChildrenAdapter(TestModel model) {
            return new CollectionAspectAdapter<TestModel, TestModel>("children", model){

                protected Iterator<TestModel> iterator_() {
                    return ((TestModel)((Object)this.subject)).children();
                }

                protected int size_() {
                    return ((TestModel)((Object)this.subject)).childrenSize();
                }
            };
        }

        public TestModel getValue() {
            return this.testModel;
        }

        public TreeNodeValueModel<Object> parent() {
            return this.parent;
        }

        public ListValueModel<TreeNodeValueModel<Object>> childrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
            this.testModel.addPropertyChangeListener("name", this.testModelListener);
        }

        protected void disengageValue() {
            this.testModel.removePropertyChangeListener("name", this.testModelListener);
        }

        @Override
        public String displayString() {
            return this.testModel.getName();
        }

        @Override
        public Icon icon() {
            return null;
        }

        public String dumpString() {
            StringWriter sw = new StringWriter();
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)sw);
            this.dumpOn(ipw);
            return sw.toString();
        }

        public void dumpOn(IndentingPrintWriter writer) {
            writer.println((Object)this);
            writer.indent();
            Iterator stream = this.childrenModel.iterator();
            while (stream.hasNext()) {
                ((TestNode)stream.next()).dumpOn(writer);
            }
            writer.undent();
        }

        public void dumpOn(OutputStream stream) {
            IndentingPrintWriter writer = new IndentingPrintWriter((Writer)new OutputStreamWriter(stream));
            this.dumpOn(writer);
            writer.flush();
        }

        public void dump() {
            this.dumpOn(System.out);
        }

        protected void testModelChanged(PropertyChangeEvent e) {
            this.fireStateChanged();
            this.firePropertyChanged("displayString", e.getOldValue(), e.getNewValue());
        }

        public TestModel getTestModel() {
            return this.testModel;
        }

        public TestNode childNamed(String name) {
            for (TreeNodeValueModel childNode : this.childrenModel) {
                if (!(childNode instanceof TestNode) || !((TestNode)childNode).getTestModel().getName().equals(name)) continue;
                return (TestNode)childNode;
            }
            throw new IllegalArgumentException("child not found: " + name);
        }

        @Override
        public int compareTo(TestNode o) {
            return this.displayString().compareTo(o.displayString());
        }

        public String toString() {
            return "Node(" + (Object)((Object)this.testModel) + ")";
        }
    }

    public class TestTreeModelListener
    implements TreeModelListener {
        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreeModelAdapterTests.fail((String)"unexpected event");
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreeModelAdapterTests.fail((String)"unexpected event");
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeModelAdapterTests.fail((String)"unexpected event");
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreeModelAdapterTests.fail((String)"unexpected event");
        }
    }

    public static class UnsortedTestNode
    extends TestNode {
        public UnsortedTestNode(TestModel testModel) {
            super(testModel);
        }

        public UnsortedTestNode(TestNode parent, TestModel testModel) {
            super(parent, testModel);
        }

        @Override
        protected ListValueModel<TreeNodeValueModel<Object>> buildChildrenModel(TestModel testModel) {
            return this.buildNodeAdapter(testModel);
        }

        @Override
        protected TestNode buildChildNode(TestModel childNode) {
            return new UnsortedTestNode(this, childNode);
        }
    }
}

