/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyListIterator;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.value.ListAspectAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.PrimitiveListTreeModel;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class PrimitiveListTreeModelTests
extends TestCase {
    TestModel testModel;
    private TreeModel treeModel;

    public PrimitiveListTreeModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testModel = this.buildTestModel();
        this.treeModel = this.buildTreeModel();
    }

    private TestModel buildTestModel() {
        return new TestModel();
    }

    private TreeModel buildTreeModel() {
        return new PrimitiveListTreeModel(this.buildListValueModel()){

            protected void primitiveChanged(int index, Object newValue) {
                if (!newValue.equals("")) {
                    PrimitiveListTreeModelTests.this.testModel.replaceName(index, (String)newValue);
                }
            }

            protected ListChangeListener buildListChangeListener() {
                return this.buildListChangeListener_();
            }
        };
    }

    private ListValueModel<?> buildListValueModel() {
        return new ListAspectAdapter<TestModel, String>("names", this.testModel){

            protected ListIterator<String> listIterator_() {
                return ((TestModel)((Object)this.subject)).names();
            }

            public String get(int index) {
                return ((TestModel)((Object)this.subject)).getName(index);
            }

            public int size() {
                return ((TestModel)((Object)this.subject)).namesSize();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testAddPrimitive() {
        this.treeModel.addTreeModelListener(new TestTreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                PrimitiveListTreeModelTests.this.verifyTreeModelEvent(e, new int[1], new String[]{"foo"});
            }
        });
        this.testModel.addName("foo");
    }

    public void testRemovePrimitive() {
        this.testModel.addName("foo");
        this.testModel.addName("bar");
        this.testModel.addName("baz");
        this.treeModel.addTreeModelListener(new TestTreeModelListener(){

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                PrimitiveListTreeModelTests.this.verifyTreeModelEvent(e, new int[]{1}, new String[]{"bar"});
            }
        });
        String name = this.testModel.removeName(1);
        PrimitiveListTreeModelTests.assertEquals((String)"bar", (String)name);
    }

    public void testReplacePrimitive() {
        this.testModel.addName("foo");
        this.testModel.addName("bar");
        this.testModel.addName("baz");
        this.treeModel.addTreeModelListener(new TestTreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                PrimitiveListTreeModelTests.this.verifyTreeModelEvent(e, new int[]{1}, new String[]{"jar"});
            }
        });
        String name = this.testModel.replaceName(1, "jar");
        PrimitiveListTreeModelTests.assertEquals((String)"bar", (String)name);
    }

    void verifyTreeModelEvent(TreeModelEvent e, int[] expectedChildIndices, String[] expectedNames) {
        PrimitiveListTreeModelTests.assertTrue((boolean)Arrays.equals(expectedChildIndices, e.getChildIndices()));
        Object[] actualChildren = e.getChildren();
        PrimitiveListTreeModelTests.assertEquals((int)expectedNames.length, (int)actualChildren.length);
        int i = 0;
        while (i < expectedNames.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)actualChildren[i];
            PrimitiveListTreeModelTests.assertEquals((Object)expectedNames[i], (Object)node.getUserObject());
            ++i;
        }
        PrimitiveListTreeModelTests.assertEquals((int)1, (int)e.getPath().length);
        PrimitiveListTreeModelTests.assertEquals((Object)this.treeModel.getRoot(), (Object)e.getPath()[0]);
        PrimitiveListTreeModelTests.assertEquals((Object)this.treeModel, (Object)e.getSource());
    }

    class TestModel
    extends AbstractModel {
        private final List<String> names = new ArrayList<String>();
        static final String NAMES_LIST = "names";

        TestModel() {
        }

        public ListIterator<String> names() {
            return new ReadOnlyListIterator(this.names);
        }

        public int namesSize() {
            return this.names.size();
        }

        public String getName(int index) {
            return this.names.get(index);
        }

        public void addName(int index, String name) {
            this.addItemToList(index, name, this.names, NAMES_LIST);
        }

        public void addName(String name) {
            this.addName(this.namesSize(), name);
        }

        public void addNames(int index, List<String> list) {
            this.addItemsToList(index, this.names, list, NAMES_LIST);
        }

        public void addNames(List<String> list) {
            this.addNames(this.namesSize(), list);
        }

        public String removeName(int index) {
            return (String)this.removeItemFromList(index, this.names, NAMES_LIST);
        }

        public List<String> removeNames(int index, int length) {
            return this.removeItemsFromList(index, length, this.names, NAMES_LIST);
        }

        public String replaceName(int index, String newName) {
            return (String)this.setItemInList(index, newName, this.names, NAMES_LIST);
        }
    }

    public class TestTreeModelListener
    implements TreeModelListener {
        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            PrimitiveListTreeModelTests.fail((String)"unexpected event");
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            PrimitiveListTreeModelTests.fail((String)"unexpected event");
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            PrimitiveListTreeModelTests.fail((String)"unexpected event");
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            PrimitiveListTreeModelTests.fail((String)"unexpected event");
        }
    }
}

