/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;

public class ArrayIteratorTests
extends TestCase {
    public ArrayIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ArrayIteratorTests.assertEquals((int)this.buildArray().length, (int)i);
    }

    public void testNext() {
        int i = 1;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            ArrayIteratorTests.assertEquals((String)"bogus element", (int)i++, (int)Integer.parseInt(stream.next()));
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ArrayIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("3")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ArrayIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testIllegalArgumentException() {
        this.triggerIllegalArgumentException(-1, 1);
        this.triggerIllegalArgumentException(8, 1);
        this.triggerIllegalArgumentException(0, -1);
        this.triggerIllegalArgumentException(0, 9);
    }

    public void testGenerics() {
        Integer[] integers = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
        int i = 0;
        Iterator<Number> stream = this.buildGenericIterator(integers);
        while (stream.hasNext()) {
            ArrayIteratorTests.assertEquals((int)i++, (int)stream.next().intValue());
        }
        ArrayIteratorTests.assertEquals((int)integers.length, (int)i);
    }

    Iterator<Number> buildGenericIterator(Integer[] integers) {
        return new ArrayIterator((Object[])integers);
    }

    public void testVarargs() {
        int i = 0;
        Iterator<Number> stream = this.buildVarArgIterator();
        while (stream.hasNext()) {
            ArrayIteratorTests.assertEquals((int)i++, (int)stream.next().intValue());
        }
        ArrayIteratorTests.assertEquals((int)3, (int)i);
    }

    Iterator<Number> buildVarArgIterator() {
        return new ArrayIterator((Object[])new Number[]{new Integer(0), new Integer(1), new Integer(2)});
    }

    void triggerIllegalArgumentException(int start, int end) {
        boolean exCaught = false;
        Iterator<String> stream = null;
        try {
            stream = this.buildIterator(start, end);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayIteratorTests.assertTrue((String)("IllegalArgumentException not thrown: " + stream), (boolean)exCaught);
    }

    Iterator<String> buildIterator() {
        return this.buildIterator(this.buildArray());
    }

    Iterator<String> buildIterator(String[] array) {
        return new ArrayIterator((Object[])array);
    }

    Iterator<String> buildIterator(int start, int end) {
        return this.buildIterator(this.buildArray(), start, end);
    }

    Iterator<String> buildIterator(String[] array, int start, int end) {
        return new ArrayIterator((Object[])array, start, end);
    }

    String[] buildArray() {
        return new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    }
}

