/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ByteArrayTools;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.SystemTools;

public class StringToolsTests
extends TestCase {
    public StringToolsTests(String name) {
        super(name);
    }

    public void testCenter() {
        StringToolsTests.assertEquals((String)"fred", (String)StringTools.center((String)"fred", (int)4));
        StringToolsTests.assertEquals((String)" fred ", (String)StringTools.center((String)"fred", (int)6));
        StringToolsTests.assertEquals((String)" fred  ", (String)StringTools.center((String)"fred", (int)7));
        StringToolsTests.assertEquals((String)"re", (String)StringTools.center((String)"fred", (int)2));
        StringToolsTests.assertEquals((String)"fre", (String)StringTools.center((String)"fred", (int)3));
    }

    public void testPad() {
        StringToolsTests.assertEquals((String)"fred", (String)StringTools.pad((String)"fred", (int)4));
        StringToolsTests.assertEquals((String)"fred  ", (String)StringTools.pad((String)"fred", (int)6));
        boolean exThrown = false;
        try {
            StringToolsTests.assertEquals((String)"fr", (String)StringTools.pad((String)"fred", (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testFit() {
        StringToolsTests.assertEquals((String)"fred", (String)StringTools.fit((String)"fred", (int)4));
        StringToolsTests.assertEquals((String)"fred  ", (String)StringTools.fit((String)"fred", (int)6));
        StringToolsTests.assertEquals((String)"fr", (String)StringTools.fit((String)"fred", (int)2));
    }

    public void testZeroPad() {
        StringToolsTests.assertEquals((String)"1234", (String)StringTools.zeroPad((String)"1234", (int)4));
        StringToolsTests.assertEquals((String)"001234", (String)StringTools.zeroPad((String)"1234", (int)6));
        boolean exThrown = false;
        try {
            StringToolsTests.assertEquals((String)"12", (String)StringTools.zeroPad((String)"1234", (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testZeroFit() {
        StringToolsTests.assertEquals((String)"1234", (String)StringTools.zeroFit((String)"1234", (int)4));
        StringToolsTests.assertEquals((String)"001234", (String)StringTools.zeroFit((String)"1234", (int)6));
        StringToolsTests.assertEquals((String)"34", (String)StringTools.zeroFit((String)"1234", (int)2));
    }

    public void testSeparateCharInt() {
        this.verifySeparate("012345", '-', 22, "012345");
        this.verifySeparate("012345", '-', 6, "012345");
        this.verifySeparate("012345", '-', 5, "01234-5");
        this.verifySeparate("012345", '-', 4, "0123-45");
        this.verifySeparate("012345", '-', 3, "012-345");
        this.verifySeparate("012345", '-', 2, "01-23-45");
        this.verifySeparate("012345", '-', 1, "0-1-2-3-4-5");
    }

    private void verifySeparate(String string, char separator, int segmentLength, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.separate((String)string, (char)separator, (int)segmentLength));
    }

    public void testDelimit() {
        this.verifyDelimit("Employee", "123", "123Employee123");
        this.verifyDelimit("123", "123", "123123123");
        this.verifyDelimit("", "123", "123123");
    }

    private void verifyDelimit(String string, String delimiter, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.delimit((String)string, (String)delimiter));
    }

    public void testQuote() {
        this.verifyQuote("Employee", "\"Employee\"");
        this.verifyQuote("123", "\"123\"");
        this.verifyQuote("", "\"\"");
        this.verifyQuote("Emp\"loyee", "\"Emp\"\"loyee\"");
    }

    private void verifyQuote(String string, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.quote((String)string));
    }

    public void testRemoveFirstOccurrence() {
        this.verifyRemoveFirstOccurrence("Emplo&yee", '&', "Employee");
        this.verifyRemoveFirstOccurrence("Emplo&yee&", '&', "Employee&");
        this.verifyRemoveFirstOccurrence("Employee &Foo", '&', "Employee Foo");
        this.verifyRemoveFirstOccurrence("Employee&", '&', "Employee");
        this.verifyRemoveFirstOccurrence("&Employee", '&', "Employee");
    }

    private void verifyRemoveFirstOccurrence(String string, char charToRemove, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.removeFirstOccurrence((String)string, (char)charToRemove));
    }

    public void testRemoveAllOccurrences() {
        this.verifyRemoveAllOccurrences("Employee Fred", ' ', "EmployeeFred");
        this.verifyRemoveAllOccurrences(" Employee ", ' ', "Employee");
        this.verifyRemoveAllOccurrences("Employee   Foo", ' ', "EmployeeFoo");
        this.verifyRemoveAllOccurrences(" Emp loyee   Foo", ' ', "EmployeeFoo");
    }

    private void verifyRemoveAllOccurrences(String string, char charToRemove, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.removeAllOccurrences((String)string, (char)charToRemove));
    }

    public void testRemoveAllWhitespace() {
        this.verifyRemoveAllWhitespace("Employee Fred\t", "EmployeeFred");
        this.verifyRemoveAllWhitespace("\tEmployee\n", "Employee");
        this.verifyRemoveAllWhitespace("Employee \t Foo", "EmployeeFoo");
        this.verifyRemoveAllWhitespace(" Emp\tloyee \n Foo", "EmployeeFoo");
    }

    private void verifyRemoveAllWhitespace(String string, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.removeAllWhitespace((String)string));
    }

    public void testCompressWhitespace() {
        this.verifyCompressWhitespace("Employee      Fred\t", "Employee Fred ");
        this.verifyCompressWhitespace("\tEmployee  \n", " Employee ");
        this.verifyCompressWhitespace("Employee \t Foo", "Employee Foo");
        this.verifyCompressWhitespace(" Emp\tloyee \n Foo ", " Emp loyee Foo ");
    }

    private void verifyCompressWhitespace(String string, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.compressWhitespace((String)string));
    }

    public void testCommonPrefixLength() {
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"fooBBB"));
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"foo", (String)"fooBBB"));
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"foo"));
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"foo", (String)"foo"));
    }

    public void testCommonPrefixLengthMax() {
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"fooBBB", (int)2));
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"foo", (String)"fooBBB", (int)2));
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"foo", (int)2));
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"foo", (String)"foo", (int)2));
    }

    public void testCapitalize() {
        this.verifyCapitalize("Oracle", "Oracle");
        this.verifyCapitalize("Oracle", "oracle");
        this.verifyCapitalize("   ", "   ");
        this.verifyCapitalize("ORACLE", "ORACLE");
        this.verifyCapitalize("", "");
        this.verifyCapitalize("A", "a");
        this.verifyCapitalize("\u00c9cole", "\u00e9cole");
    }

    private void verifyCapitalize(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.capitalize((String)string));
    }

    public void testUncapitalize() {
        this.verifyUncapitalize("oracle", "Oracle");
        this.verifyUncapitalize("oracle", "oracle");
        this.verifyUncapitalize("   ", "   ");
        this.verifyUncapitalize("ORACLE", "ORACLE");
        this.verifyUncapitalize("", "");
        this.verifyUncapitalize("a", "A");
        this.verifyUncapitalize("\u00e9cole", "\u00c9cole");
    }

    private void verifyUncapitalize(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.uncapitalize((String)string));
    }

    public void testIsBlank() {
        StringToolsTests.assertTrue((boolean)StringTools.isBlank(null));
        StringToolsTests.assertTrue((boolean)StringTools.isBlank((String)""));
        StringToolsTests.assertTrue((boolean)StringTools.isBlank((String)"      "));
        StringToolsTests.assertTrue((boolean)StringTools.isBlank((String)"      \t\t   "));
        StringToolsTests.assertTrue((boolean)StringTools.isBlank((String)("      \t\t   " + StringTools.CR)));
    }

    public void testEquals() {
        StringToolsTests.assertTrue((boolean)ObjectTools.equals(null, null));
        StringToolsTests.assertFalse((boolean)ObjectTools.equals(null, (Object)"asdf"));
        StringToolsTests.assertFalse((boolean)ObjectTools.equals((Object)"asdf", null));
        StringToolsTests.assertTrue((boolean)ObjectTools.equals((Object)"asdf", (Object)"asdf"));
        StringToolsTests.assertFalse((boolean)ObjectTools.equals((Object)"asdf", (Object)"ASDF"));
    }

    public void testEqualsIgnoreCase() {
        StringToolsTests.assertTrue((boolean)StringTools.equalsIgnoreCase(null, null));
        StringToolsTests.assertFalse((boolean)StringTools.equalsIgnoreCase(null, (String)"asdf"));
        StringToolsTests.assertFalse((boolean)StringTools.equalsIgnoreCase((String)"asdf", null));
        StringToolsTests.assertTrue((boolean)StringTools.equalsIgnoreCase((String)"asdf", (String)"asdf"));
        StringToolsTests.assertTrue((boolean)StringTools.equalsIgnoreCase((String)"asdf", (String)"ASDF"));
    }

    public void testStartsWithIgnoreCase() {
        StringToolsTests.assertTrue((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"as"));
        StringToolsTests.assertTrue((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"aS"));
        StringToolsTests.assertTrue((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)""));
        StringToolsTests.assertTrue((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"A"));
        StringToolsTests.assertFalse((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"bsdf"));
        StringToolsTests.assertFalse((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"g"));
        StringToolsTests.assertFalse((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"asdg"));
        StringToolsTests.assertFalse((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"asdfg"));
        StringToolsTests.assertFalse((boolean)StringTools.startsWithIgnoreCase((String)"asdf", (String)"asdfgggggg"));
    }

    public void testIsUppercase() {
        this.verifyIsUppercase("FOO");
        this.verifyIsUppercase("FOO2");
        this.verifyIsUppercase("F O O");
        this.denyIsUppercase("Foo");
        this.denyIsUppercase("");
    }

    private void verifyIsUppercase(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.isUppercase((String)s));
    }

    private void denyIsUppercase(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.isUppercase((String)s));
    }

    public void testIsLowercase() {
        this.verifyIsLowercase("foo");
        this.verifyIsLowercase("foo2");
        this.verifyIsLowercase("f o o");
        this.denyIsLowercase("Foo");
        this.denyIsLowercase("");
    }

    private void verifyIsLowercase(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.isLowercase((String)s));
    }

    private void denyIsLowercase(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.isLowercase((String)s));
    }

    public void testConvertHexStringToByteArray_empty() throws Exception {
        String s = "";
        byte[] byteArray = StringTools.convertHexStringToByteArray((String)s);
        StringToolsTests.assertEquals((int)0, (int)byteArray.length);
        StringToolsTests.assertTrue((boolean)Arrays.equals(ByteArrayTools.EMPTY_BYTE_ARRAY, byteArray));
    }

    public void testConvertHexStringToByteArray_oddLength() throws Exception {
        String s = "CAFEE";
        boolean exCaught = false;
        try {
            byte[] byteArray = StringTools.convertHexStringToByteArray((String)s);
            StringToolsTests.fail((String)("bogus byte array: " + Arrays.toString(byteArray)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        StringToolsTests.assertTrue((boolean)exCaught);
    }

    public void testConvertHexStringToByteArray_illegalCharacter1() throws Exception {
        this.verifyConvertHexStringToByteArray_illegalCharacter("CAFEX0CAFEX0");
    }

    public void testConvertHexStringToByteArray_illegalCharacter2() throws Exception {
        this.verifyConvertHexStringToByteArray_illegalCharacter("CAFE0XCAFE0x");
    }

    private void verifyConvertHexStringToByteArray_illegalCharacter(String s) throws Exception {
        boolean exCaught = false;
        try {
            byte[] byteArray = StringTools.convertHexStringToByteArray((String)s);
            StringToolsTests.fail((String)("bogus byte array: " + Arrays.toString(byteArray)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        StringToolsTests.assertTrue((boolean)exCaught);
    }

    public void testConvertHexStringToByteArray_ok() throws Exception {
        String s = "74657374";
        StringToolsTests.assertEquals((String)"test", (String)new String(StringTools.convertHexStringToByteArray((String)s)));
    }

    public void testConvertHexStringToByteArray_negative() throws Exception {
        String s = StringToolsTests.getHexCafe();
        StringToolsTests.assertEquals((String)"caf\u00e9", (String)new String(StringTools.convertHexStringToByteArray((String)s)));
    }

    public void testConvertHexStringToByteArray_lowercase() throws Exception {
        String s = StringToolsTests.getHexCafe().toLowerCase();
        StringToolsTests.assertEquals((String)"caf\u00e9", (String)new String(StringTools.convertHexStringToByteArray((String)s)));
    }

    public static String getHexCafe() {
        if (SystemTools.fileEncodingIsWindows()) {
            return "636166E9";
        }
        if (SystemTools.fileEncodingIsUTF8()) {
            return "636166C3A9";
        }
        return null;
    }

    public void testConvertCamelCaseToAllCaps() {
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"test"));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TEST"));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTESTTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST_T", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTestT"));
    }

    public void testConvertCamelCaseToAllCapsMaxLength() {
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"test", (int)44));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"test", (int)4));
        StringToolsTests.assertEquals((String)"TES", (String)StringTools.convertCamelCaseToAllCaps((String)"test", (int)3));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TEST", (int)5));
        StringToolsTests.assertEquals((String)"TE", (String)StringTools.convertCamelCaseToAllCaps((String)"TEST", (int)2));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)9));
        StringToolsTests.assertEquals((String)"TEST_TES", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)8));
        StringToolsTests.assertEquals((String)"TEST_T", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)6));
        StringToolsTests.assertEquals((String)"TEST_", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)5));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)4));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTest", (int)9));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTest", (int)1100));
        StringToolsTests.assertEquals((String)"TEST_TEST_", (String)StringTools.convertCamelCaseToAllCaps((String)"testTESTTest", (int)10));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTest", (int)14));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST_T", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTestT", (int)16));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST_", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTestT", (int)15));
    }

    public void testConvertAllCapsToCamelCase() {
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"TEST_", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"TEST____", (boolean)false));
        StringToolsTests.assertEquals((String)"Test", (String)StringTools.convertAllCapsToCamelCase((String)"TEST", (boolean)true));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"TeST", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertAllCapsToCamelCase((String)"TEST_TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertAllCapsToCamelCase((String)"TEST___TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTest", (String)StringTools.convertAllCapsToCamelCase((String)"TEST_TEST", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTest", (String)StringTools.convertAllCapsToCamelCase((String)"TEST_TEST_TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTest", (String)StringTools.convertAllCapsToCamelCase((String)"TEST_TEST_TEST", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"TEST_TEST_TEST_T", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"_TEST_TEST_TEST_T", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"__TEST_TEST_TEST_T", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"TEST_TEST_TEST_T", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"_TEST_TEST_TEST_T", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"__TEST_TEST_TEST_T", (boolean)true));
    }

    public void testConvertAllCapsToCamelCaseLowercase() {
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"test", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"test_", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"test____", (boolean)false));
        StringToolsTests.assertEquals((String)"Test", (String)StringTools.convertAllCapsToCamelCase((String)"test", (boolean)true));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertAllCapsToCamelCase((String)"test", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertAllCapsToCamelCase((String)"test_test", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertAllCapsToCamelCase((String)"test___test", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTest", (String)StringTools.convertAllCapsToCamelCase((String)"test_test", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTest", (String)StringTools.convertAllCapsToCamelCase((String)"test_test_test", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTest", (String)StringTools.convertAllCapsToCamelCase((String)"test_test_test", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"test_test_test_t", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"_test_test_test_t", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"__test_test_test_t", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"test_test_test_t", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"_test_test_test_t", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertAllCapsToCamelCase((String)"__test_test_test_t", (boolean)true));
    }

    public void testIsQuoted() {
        this.denyIsQuoted("foo");
        this.verifyIsQuoted("\"foo\"");
        this.denyIsQuoted("");
        this.verifyIsQuoted("\"\"");
        this.denyIsQuoted("\"");
        this.denyIsQuoted(" ");
        this.denyIsQuoted("''");
        this.denyIsQuoted("'foo'");
    }

    private void verifyIsQuoted(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.isQuoted((String)s));
    }

    private void denyIsQuoted(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.isQuoted((String)s));
    }

    public void testIsParenthetical() {
        this.denyIsParenthetical("foo");
        this.verifyIsParenthetical("(foo)");
        this.denyIsParenthetical("");
        this.verifyIsParenthetical("()");
        this.denyIsParenthetical("(");
        this.denyIsParenthetical(" ");
        this.denyIsParenthetical("''");
        this.denyIsParenthetical("'foo'");
    }

    private void verifyIsParenthetical(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.isParenthetical((String)s));
    }

    private void denyIsParenthetical(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.isParenthetical((String)s));
    }

    public void testIsBracketed() {
        this.denyIsBracketed("foo");
        this.verifyIsBracketed("[foo]");
        this.denyIsBracketed("");
        this.verifyIsBracketed("[]");
        this.denyIsBracketed("[");
        this.denyIsBracketed(" ");
        this.denyIsBracketed("''");
        this.denyIsBracketed("'foo'");
    }

    private void verifyIsBracketed(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.isBracketed((String)s));
    }

    private void denyIsBracketed(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.isBracketed((String)s));
    }

    public void testIsBraced() {
        this.denyIsBraced("foo");
        this.verifyIsBraced("{foo}");
        this.denyIsBraced("");
        this.verifyIsBraced("{}");
        this.denyIsBraced("{");
        this.denyIsBraced(" ");
        this.denyIsBraced("''");
        this.denyIsBraced("'foo'");
    }

    private void verifyIsBraced(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.isBraced((String)s));
    }

    private void denyIsBraced(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.isBraced((String)s));
    }

    public void testIsChevroned() {
        this.denyIsChevroned("foo");
        this.verifyIsChevroned("<foo>");
        this.denyIsChevroned("");
        this.verifyIsChevroned("<>");
        this.denyIsChevroned("{");
        this.denyIsChevroned(" ");
        this.denyIsChevroned("''");
        this.denyIsChevroned("'foo'");
    }

    private void verifyIsChevroned(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.isChevroned((String)s));
    }

    private void denyIsChevroned(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.isChevroned((String)s));
    }

    public void testIsDelimited() {
        this.denyIsDelimited("foo", '?');
        this.verifyIsDelimited("?foo?", '?');
        this.denyIsDelimited("", '?');
        this.verifyIsDelimited("\"\"", '\"');
        this.verifyIsDelimited("?xx?", '?');
        this.denyIsDelimited("?xx]", '?');
        this.denyIsDelimited("\"", '\"');
        this.denyIsDelimited(" ", ' ');
        this.denyIsDelimited("''", '\"');
        this.denyIsDelimited("'foo'", '?');
    }

    private void verifyIsDelimited(String s, char c) {
        StringToolsTests.assertTrue((boolean)StringTools.isDelimited((String)s, (char)c));
    }

    private void denyIsDelimited(String s, char c) {
        StringToolsTests.assertFalse((boolean)StringTools.isDelimited((String)s, (char)c));
    }

    public void testIsDelimited2() {
        this.denyIsDelimited2("foo", '[', ']');
        this.verifyIsDelimited2("{foo}", '{', '}');
        this.denyIsDelimited2("", '[', ']');
        this.verifyIsDelimited2("[]", '[', ']');
        this.verifyIsDelimited2("[xx]", '[', ']');
        this.denyIsDelimited2("?xx]", '[', ']');
        this.denyIsDelimited2("\"", '[', ']');
        this.denyIsDelimited2(" ", '[', ']');
        this.denyIsDelimited2("''", '[', ']');
        this.denyIsDelimited2("'foo'", '[', ']');
    }

    private void verifyIsDelimited2(String s, char start, char end) {
        StringToolsTests.assertTrue((boolean)StringTools.isDelimited((String)s, (char)start, (char)end));
    }

    private void denyIsDelimited2(String s, char start, char end) {
        StringToolsTests.assertFalse((boolean)StringTools.isDelimited((String)s, (char)start, (char)end));
    }

    public void testUndelimit() {
        this.verifyUndelimit("\"foo\"", "foo");
        this.verifyUndelimit("\"\"", "");
        this.verifyUndelimit("'foo'", "foo");
        this.verifyUndelimit("\"fo\"\"o\"", "fo\"o");
        this.verifyUndelimit("\"foo\"\"\"", "foo\"");
        this.verifyUndelimit("\"\"\"foo\"", "\"foo");
        this.verifyUndelimit("[foo]", "foo");
        this.verifyUndelimit("\"\"\"", "\"");
        this.verifyUndelimit("\"foo\"bar\"", "foo\"");
        this.verifyUndelimit("\"foo\"\"", "foo\"");
    }

    private void verifyUndelimit(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.undelimit((String)s));
    }

    public void testUndelimitInt() {
        this.verifyUndelimitInt("\"foo\"", 2, "o");
        this.verifyUndelimitInt("\"\"foo\"\"", 2, "foo");
        this.verifyUndelimitInt("'foo'", 2, "o");
    }

    private void verifyUndelimitInt(String s, int count, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.undelimit((String)s, (int)count));
    }

    public void testUndelimitIntException() {
        this.denyUndelimitInt("\"\"", 2);
        this.denyUndelimitInt("'o'", 2);
    }

    private void denyUndelimitInt(String s, int count) {
        boolean exCaught = false;
        try {
            String bogus = StringTools.undelimit((String)s, (int)count);
            StringToolsTests.fail((String)("invalid string: " + bogus));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        StringToolsTests.assertTrue((boolean)exCaught);
    }

    public void testConvertToJavaStringLiteral() {
        this.verifyConvertToJavaStringLiteral("", "\"\"");
        this.verifyConvertToJavaStringLiteral("\"\"", "\"\\\"\\\"\"");
        this.verifyConvertToJavaStringLiteral("'foo'", "\"'foo'\"");
        this.verifyConvertToJavaStringLiteral("foo\bbar", "\"foo\\bbar\"");
        this.verifyConvertToJavaStringLiteral("foo\n\tbar", "\"foo\\n\\tbar\"");
        this.verifyConvertToJavaStringLiteral("foo\"bar", "\"foo\\\"bar\"");
        this.verifyConvertToJavaStringLiteral("foo\\bar", "\"foo\\\\bar\"");
    }

    private void verifyConvertToJavaStringLiteral(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToJavaStringLiteral((String)s));
    }

    public void testConvertToJavaStringLiteralContent() {
        this.verifyConvertToJavaStringLiteralContent("", "");
        this.verifyConvertToJavaStringLiteralContent("\"\"", "\\\"\\\"");
        this.verifyConvertToJavaStringLiteralContent("'foo'", "'foo'");
        this.verifyConvertToJavaStringLiteralContent("foo\bbar", "foo\\bbar");
        this.verifyConvertToJavaStringLiteralContent("foo\n\tbar", "foo\\n\\tbar");
        this.verifyConvertToJavaStringLiteralContent("foo\"bar", "foo\\\"bar");
        this.verifyConvertToJavaStringLiteralContent("foo\\bar", "foo\\\\bar");
    }

    private void verifyConvertToJavaStringLiteralContent(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToJavaStringLiteralContent((String)s));
    }

    public void testConvertToXmlAttributeValue() {
        this.verifyConvertToXmlAttributeValue("", "\"\"");
        this.verifyConvertToXmlAttributeValue("\"", "'\"'");
        this.verifyConvertToXmlAttributeValue("\"\"", "'\"\"'");
        this.verifyConvertToXmlAttributeValue("'", "\"'\"");
        this.verifyConvertToXmlAttributeValue("''", "\"''\"");
        this.verifyConvertToXmlAttributeValue("\"'\"", "\"&quot;'&quot;\"");
        this.verifyConvertToXmlAttributeValue("\"''\"", "\"&quot;''&quot;\"");
        this.verifyConvertToXmlAttributeValue("'foo'", "\"'foo'\"");
        this.verifyConvertToXmlAttributeValue("\"foo\"", "'\"foo\"'");
        this.verifyConvertToXmlAttributeValue("\"foo\" 'bar'", "\"&quot;foo&quot; 'bar'\"");
        this.verifyConvertToXmlAttributeValue("foo & bar", "\"foo &amp; bar\"");
        this.verifyConvertToXmlAttributeValue("\"foo & bar\"", "'\"foo &amp; bar\"'");
        this.verifyConvertToXmlAttributeValue("foo <<< bar", "\"foo &lt;&lt;&lt; bar\"");
        this.verifyConvertToXmlAttributeValue("\"foo <<< bar\"", "'\"foo &lt;&lt;&lt; bar\"'");
    }

    private void verifyConvertToXmlAttributeValue(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToXmlAttributeValue((String)s));
    }

    public void testConvertToXmlElementText() {
        this.verifyConvertToXmlElementText("", "");
        this.verifyConvertToXmlElementText("\"", "\"");
        this.verifyConvertToXmlElementText("\"\"", "\"\"");
        this.verifyConvertToXmlElementText("'", "'");
        this.verifyConvertToXmlElementText("''", "''");
        this.verifyConvertToXmlElementText("\"'\"", "\"'\"");
        this.verifyConvertToXmlElementText("\"''\"", "\"''\"");
        this.verifyConvertToXmlElementText("'foo'", "'foo'");
        this.verifyConvertToXmlElementText("foo & bar", "foo &amp; bar");
        this.verifyConvertToXmlElementText("foo &", "foo &amp;");
        this.verifyConvertToXmlElementText("& bar", "&amp; bar");
        this.verifyConvertToXmlElementText("\"foo & bar\"", "\"foo &amp; bar\"");
        this.verifyConvertToXmlElementText("foo <<< bar", "foo &lt;&lt;&lt; bar");
        this.verifyConvertToXmlElementText("\"foo <<< bar\"", "\"foo &lt;&lt;&lt; bar\"");
    }

    private void verifyConvertToXmlElementText(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToXmlElementText((String)s));
    }

    public void testConvertToXmlElementCDATA() {
        String START = "<![CDATA[";
        String END = "]]>";
        this.verifyConvertToXmlElementCDATA("", String.valueOf(START) + END);
        this.verifyConvertToXmlElementCDATA("\"", String.valueOf(START) + "\"" + END);
        this.verifyConvertToXmlElementCDATA("\"\"", String.valueOf(START) + "\"\"" + END);
        this.verifyConvertToXmlElementCDATA("'", String.valueOf(START) + "'" + END);
        this.verifyConvertToXmlElementCDATA("''", String.valueOf(START) + "''" + END);
        this.verifyConvertToXmlElementCDATA("\"'\"", String.valueOf(START) + "\"'\"" + END);
        this.verifyConvertToXmlElementCDATA("\"''\"", String.valueOf(START) + "\"''\"" + END);
        this.verifyConvertToXmlElementCDATA("'foo'", String.valueOf(START) + "'foo'" + END);
        this.verifyConvertToXmlElementCDATA("foo & bar", String.valueOf(START) + "foo & bar" + END);
        this.verifyConvertToXmlElementCDATA("foo &", String.valueOf(START) + "foo &" + END);
        this.verifyConvertToXmlElementCDATA("& bar", String.valueOf(START) + "& bar" + END);
        this.verifyConvertToXmlElementCDATA("\"foo & bar\"", String.valueOf(START) + "\"foo & bar\"" + END);
        this.verifyConvertToXmlElementCDATA("foo <<< bar", String.valueOf(START) + "foo <<< bar" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <<< bar\"", String.valueOf(START) + "\"foo <<< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <&< bar\"", String.valueOf(START) + "\"foo <&< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <]< bar\"", String.valueOf(START) + "\"foo <]< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <]]< bar\"", String.valueOf(START) + "\"foo <]]< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <]]>< bar\"", String.valueOf(START) + "\"foo <]]&gt;< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("foo <]", String.valueOf(START) + "foo <]" + END);
        this.verifyConvertToXmlElementCDATA("foo <]]", String.valueOf(START) + "foo <]]" + END);
        this.verifyConvertToXmlElementCDATA("foo <]]>", String.valueOf(START) + "foo <]]&gt;" + END);
        this.verifyConvertToXmlElementCDATA("]foo", String.valueOf(START) + "]foo" + END);
        this.verifyConvertToXmlElementCDATA("]]foo", String.valueOf(START) + "]]foo" + END);
        this.verifyConvertToXmlElementCDATA("]]>foo", String.valueOf(START) + "]]&gt;foo" + END);
    }

    private void verifyConvertToXmlElementCDATA(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToXmlElementCDATA((String)s));
    }
}

