/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen;

import org.eclipse.persistence.tools.utility.iterable.IterableTools;

public enum DatabaseType {
    MySql("MySQL", "com.mysql.jdbc.Driver"),
    Oracle("Oracle", "oracle.jdbc.driver.OracleDriver");

    private String driver;
    private String typeName;

    private DatabaseType(String typeName, String driver) {
        this.typeName = typeName;
        this.driver = driver;
    }

    public static Iterable<DatabaseType> types() {
        return IterableTools.iterable((Object[])DatabaseType.values());
    }

    public static DatabaseType value(String value) {
        DatabaseType[] databaseTypeArray = DatabaseType.values();
        int n = databaseTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseType type = databaseTypeArray[n2];
            if (type.typeName.equals(value)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public String getDatabaseDriver() {
        return this.driver;
    }

    public String getName() {
        return this.typeName;
    }

    public String toString() {
        return this.typeName;
    }
}

