/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalVersionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperclass;
import org.eclipse.persistence.tools.utility.TextRange;

final class VersionMapping
extends ConvertibleMapping
implements ExternalVersionMapping {
    VersionMapping(MappedSuperclass parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalEntityColumn addColumn() {
        EntityColumn column = this.buildColumn();
        column.addSelf();
        return column;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("access");
        names.add("mutable");
        names.add("attribute-type");
        return names;
    }

    private EntityColumn buildColumn() {
        return new EntityColumn(this, "column", -1);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("column");
        names.add("temporal");
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    @Override
    public EntityColumn getColumn() {
        if (this.hasChild("column")) {
            return this.buildColumn();
        }
        return null;
    }

    @Override
    public String getConvert() {
        return this.getChildTextNode("convert");
    }

    @Override
    protected String getElementName() {
        return "version";
    }

    @Override
    public TextRange getMutableTextRange() {
        return this.getAttributeTextRange("mutable");
    }

    @Override
    public String getNoSqlField() {
        return null;
    }

    @Override
    public TemporalType getTemporalType() {
        return this.getChildEnumNode("temporal", TemporalType.class);
    }

    @Override
    public TextRange getTemporalTypeTextRange() {
        return this.getChildTextNodeTextRange("temporal");
    }

    @Override
    public boolean hasColumn() {
        return this.hasChild("column");
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute("mutable");
    }

    @Override
    public void removeColumn() {
        EntityColumn column = this.buildColumn();
        column.removeSelf();
    }

    @Override
    public void setColumn(String columnName) {
        EntityColumn column = this.getColumn();
        if (column == null && columnName != null) {
            column = this.buildColumn();
            column.addSelf();
        } else if (column != null && columnName == null) {
            column.removeSelf();
        }
        if (columnName != null) {
            column.setName(columnName);
        }
    }

    @Override
    public void setConvert(String convert) {
        this.updateChildTextNode("convert", convert);
    }

    @Override
    public void setMutable(Boolean mutable) {
        this.setAttribute("mutable", mutable);
    }

    @Override
    public void setNoSqlField(String field) {
    }

    @Override
    public void setTemporalType(TemporalType type) {
        this.updateChildTextNode("temporal", (Enum<?>)type);
    }
}

