/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalConversionValue;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class ConversionValue
extends AbstractExternalForm
implements ExternalConversionValue {
    private int index;

    ConversionValue(ObjectTypeConverter parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("data-value");
        names.add("object-value");
        return names;
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public String getDataValue() {
        return this.getAttribute("data-value");
    }

    @Override
    public TextRange getDataValueTextRange() {
        return this.getAttributeTextRange("data-value");
    }

    @Override
    public Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "conversion-value";
    }

    @Override
    @Deprecated
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getObjectValue() {
        return this.getAttribute("object-value");
    }

    @Override
    public TextRange getObjectValueTextRange() {
        return this.getAttributeTextRange("object-value");
    }

    @Override
    public void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }

    @Override
    public void setDataValue(String value) {
        this.setAttribute("data-value", value);
    }

    @Override
    public void setObjectValue(String value) {
        this.setAttribute("object-value", value);
    }
}

