/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalQueryHint;
import org.eclipse.persistence.tools.mapping.orm.dom.QueryHint;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

abstract class AbstractQuery
extends AbstractExternalForm
implements ExternalNamedQuery {
    private int index;

    AbstractQuery(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public final ExternalQueryHint addQueryHint(String name, String value) {
        QueryHint queryHint = this.buildQueryHint(-1);
        queryHint.addSelf();
        queryHint.setName(name);
        queryHint.setValue(value);
        return queryHint;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("query");
        names.add("hint");
        return names;
    }

    private QueryHint buildQueryHint(int index) {
        return new QueryHint(this, index);
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public final String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    public final Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    @Deprecated
    public int getIndex() {
        return this.index;
    }

    @Override
    public final String getName() {
        return this.getAttribute("name");
    }

    @Override
    public final TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public final String getQuery() {
        return this.getChildTextNode("query");
    }

    @Override
    public final QueryHint getQueryHint(int index) {
        if (this.hasChild("hint", index)) {
            return this.buildQueryHint(index);
        }
        return null;
    }

    @Override
    public final TextRange getQueryTextRange() {
        return this.getChildTextNodeTextRange("query");
    }

    @Override
    public final List<ExternalQueryHint> queryHints() {
        int count = this.queryHintsSize();
        ArrayList<ExternalQueryHint> queryHints = new ArrayList<ExternalQueryHint>(count);
        int index = 0;
        while (index < count) {
            QueryHint queryHint = this.buildQueryHint(index);
            queryHints.add(queryHint);
            ++index;
        }
        return queryHints;
    }

    @Override
    public final int queryHintsSize() {
        return this.getChildrenSize("hint");
    }

    @Override
    public final void removeQueryHint(int index) {
        QueryHint queryHint = this.buildQueryHint(index);
        queryHint.removeSelf();
    }

    @Override
    public final void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public final void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public final void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public final void setQuery(String query) {
        this.updateChildTextNode("query", query);
    }
}

