/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityListener;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

abstract class AbstractEntityListener
extends AbstractExternalForm
implements ExternalEntityListener {
    private int index;

    AbstractEntityListener(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("pre-persist");
        names.add("post-persist");
        names.add("pre-remove");
        names.add("post-remove");
        names.add("pre-update");
        names.add("post-update");
        names.add("post-load");
        return names;
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public String getClassName() {
        return this.getAttribute("class");
    }

    @Override
    public TextRange getClassNameTextRange() {
        return this.getAttributeTextRange("class");
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    protected String getElementName() {
        return "entity-listener";
    }

    @Override
    @Deprecated
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPostLoadMethod() {
        return this.getChildAttribute("post-load", "method-name");
    }

    @Override
    public String getPostLoadMethodDescription() {
        return this.getChildAttribute("post-load", "description");
    }

    @Override
    public TextRange getPostLoadMethodTextRange() {
        return this.getChildAttributeTextRange("post-load", "description");
    }

    @Override
    public String getPostPersistMethod() {
        return this.getChildAttribute("post-persist", "method-name");
    }

    @Override
    public String getPostPersistMethodDescription() {
        return this.getChildAttribute("post-persist", "description");
    }

    @Override
    public TextRange getPostPersistMethodTextRange() {
        return this.getChildAttributeTextRange("post-persist", "description");
    }

    @Override
    public String getPostRemoveMethod() {
        return this.getChildAttribute("post-remove", "method-name");
    }

    @Override
    public String getPostRemoveMethodDescription() {
        return this.getChildAttribute("post-remove", "description");
    }

    @Override
    public TextRange getPostRemoveMethodTextRange() {
        return this.getChildAttributeTextRange("post-remove", "description");
    }

    @Override
    public String getPostUpdateMethod() {
        return this.getChildAttribute("post-update", "method-name");
    }

    @Override
    public String getPostUpdateMethodDescription() {
        return this.getChildAttribute("post-update", "description");
    }

    @Override
    public TextRange getPostUpdateMethodTextRange() {
        return this.getChildAttributeTextRange("post-update", "description");
    }

    @Override
    public String getPrePersistMethod() {
        return this.getChildAttribute("pre-persist", "method-name");
    }

    @Override
    public String getPrePersistMethodDescription() {
        return this.getChildAttribute("pre-persist", "description");
    }

    @Override
    public TextRange getPrePersistMethodTextRange() {
        return this.getChildAttributeTextRange("pre-persist", "description");
    }

    @Override
    public String getPreRemoveMethod() {
        return this.getChildAttribute("pre-remove", "method-name");
    }

    @Override
    public String getPreRemoveMethodDescription() {
        return this.getChildAttribute("pre-remove", "description");
    }

    @Override
    public TextRange getPreRemoveMethodTextRange() {
        return this.getChildAttributeTextRange("pre-remove", "description");
    }

    @Override
    public String getPreUpdateMethod() {
        return this.getChildAttribute("pre-update", "method-name");
    }

    @Override
    public String getPreUpdateMethodDescription() {
        return this.getChildAttribute("pre-update", "description");
    }

    @Override
    public TextRange getPreUpdateMethodTextRange() {
        return this.getChildAttributeTextRange("pre-update", "description");
    }

    @Override
    public void setClassName(String name) {
        this.setAttribute("class", name);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public void setPostLoadMethod(String value) {
        this.updateChildAttribute("post-load", "method-name", value);
    }

    @Override
    public void setPostLoadMethodDescription(String name) {
        this.updateChildChildTextNode("post-load", "description", name);
    }

    @Override
    public void setPostPersistMethod(String value) {
        this.updateChildAttribute("post-persist", "method-name", value);
    }

    @Override
    public void setPostPersistMethodDescription(String name) {
        this.updateChildChildTextNode("post-persist", "description", name);
    }

    @Override
    public void setPostRemoveMethod(String value) {
        this.updateChildAttribute("post-remove", "method-name", value);
    }

    @Override
    public void setPostRemoveMethodDescription(String name) {
        this.updateChildChildTextNode("post-remove", "description", name);
    }

    @Override
    public void setPostUpdateMethod(String value) {
        this.updateChildAttribute("post-update", "method-name", value);
    }

    @Override
    public void setPostUpdateMethodDescription(String name) {
        this.updateChildChildTextNode("post-update", "description", name);
    }

    @Override
    public void setPrePersistMethod(String value) {
        this.updateChildAttribute("pre-persist", "method-name", value);
    }

    @Override
    public void setPrePersistMethodDescription(String name) {
        this.updateChildChildTextNode("pre-persist", "description", name);
    }

    @Override
    public void setPreRemoveMethod(String value) {
        this.updateChildAttribute("pre-remove", "method-name", value);
    }

    @Override
    public void setPreRemoveMethodDescription(String name) {
        this.updateChildChildTextNode("pre-remove", "description", name);
    }

    @Override
    public void setPreUpdateMethod(String value) {
        this.updateChildAttribute("pre-update", "method-name", value);
    }

    @Override
    public void setPreUpdateMethodDescription(String name) {
        this.updateChildChildTextNode("pre-update", "description", name);
    }
}

