/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.reference;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.reference.IntReference;
import org.eclipse.persistence.tools.utility.reference.ModifiableIntReference;

public final class SimpleIntReference
implements ModifiableIntReference,
Cloneable,
Serializable {
    private volatile int value = 0;
    private static final long serialVersionUID = 1L;

    public SimpleIntReference(int count) {
        this.value = count;
    }

    public SimpleIntReference() {
        this(0);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean equals(int v) {
        return this.value == v;
    }

    @Override
    public boolean notEqual(int v) {
        return this.value != v;
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public boolean isNotZero() {
        return this.value != 0;
    }

    @Override
    public boolean isGreaterThan(int v) {
        return this.value > v;
    }

    @Override
    public boolean isGreaterThanOrEqual(int v) {
        return this.value >= v;
    }

    @Override
    public boolean isLessThan(int v) {
        return this.value < v;
    }

    @Override
    public boolean isLessThanOrEqual(int v) {
        return this.value <= v;
    }

    @Override
    public boolean isPositive() {
        return this.isGreaterThan(0);
    }

    @Override
    public boolean isNotPositive() {
        return this.isLessThanOrEqual(0);
    }

    @Override
    public boolean isNegative() {
        return this.isLessThan(0);
    }

    @Override
    public boolean isNotNegative() {
        return this.isGreaterThanOrEqual(0);
    }

    @Override
    public int abs() {
        return Math.abs(this.value);
    }

    @Override
    public int neg() {
        return -this.value;
    }

    @Override
    public int add(int v) {
        return this.value + v;
    }

    @Override
    public int subtract(int v) {
        return this.value - v;
    }

    @Override
    public int multiply(int v) {
        return this.value * v;
    }

    @Override
    public int divide(int v) {
        return this.value / v;
    }

    @Override
    public int remainder(int v) {
        return this.value % v;
    }

    @Override
    public int min(int v) {
        return Math.min(this.value, v);
    }

    @Override
    public int max(int v) {
        return Math.max(this.value, v);
    }

    @Override
    public double pow(int v) {
        return Math.pow(this.value, v);
    }

    @Override
    public int setValue(int value) {
        int old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public int setZero() {
        return this.setValue(0);
    }

    @Override
    public int increment() {
        return ++this.value;
    }

    @Override
    public int decrement() {
        return --this.value;
    }

    @Override
    public int compareTo(IntReference ref) {
        int v = ref.getValue();
        return this.value < v ? -1 : (this.value == v ? 0 : 1);
    }

    public SimpleIntReference clone() {
        try {
            return (SimpleIntReference)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

