/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value.swing;

import java.util.Arrays;
import java.util.List;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;

public class ListSpinnerModelAdapter
extends SpinnerListModel {
    private final Object defaultValue;
    private final ModifiablePropertyValueModel<Object> valueHolder;
    private final PropertyChangeListener valueChangeListener;
    private static final long serialVersionUID = 1L;

    public ListSpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder) {
        this(valueHolder, valueHolder.getValue());
    }

    public ListSpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object defaultValue) {
        this(valueHolder, new Object[]{defaultValue}, defaultValue);
    }

    public ListSpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object[] values) {
        this(valueHolder, values, values[0]);
    }

    public ListSpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object[] values, Object defaultValue) {
        this(valueHolder, Arrays.asList(values), defaultValue);
    }

    public ListSpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, List<Object> values) {
        this(valueHolder, values, values.get(0));
    }

    public ListSpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, List<Object> values, Object defaultValue) {
        super(values);
        this.valueHolder = valueHolder;
        this.valueChangeListener = this.buildValueChangeListener();
        this.defaultValue = defaultValue;
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildValueChangeListener_());
    }

    protected PropertyChangeListener buildValueChangeListener_() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                ListSpinnerModelAdapter.this.synchronize(event.getNewValue());
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.valueHolder.getValue()));
        }
        return super.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.valueHolder.setValue(value);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
            this.synchronize(this.valueHolder.getValue());
        }
        super.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
        }
    }

    protected Object getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.valueHolder);
    }
}

