/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.Arrays;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.ListAddEvent;
import org.eclipse.persistence.tools.utility.model.event.ListChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.ListClearEvent;
import org.eclipse.persistence.tools.utility.model.event.ListMoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListRemoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListReplaceEvent;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.ValueAspectAdapter;

public class ValueListAdapter<V extends Model>
extends ValueAspectAdapter<V> {
    protected final String[] listNames;
    protected final ListChangeListener valueListListener;

    public ValueListAdapter(ModifiablePropertyValueModel<V> valueHolder, String ... listNames) {
        super(valueHolder);
        if (listNames == null) {
            throw new NullPointerException();
        }
        this.listNames = listNames;
        this.valueListListener = this.buildValueListListener();
    }

    protected ListChangeListener buildValueListListener() {
        return new ListChangeListener(){

            @Override
            public void itemsAdded(ListAddEvent event) {
                ValueListAdapter.this.itemsAdded(event);
            }

            @Override
            public void itemsRemoved(ListRemoveEvent event) {
                ValueListAdapter.this.itemsRemoved(event);
            }

            @Override
            public void itemsReplaced(ListReplaceEvent event) {
                ValueListAdapter.this.itemsReplaced(event);
            }

            @Override
            public void itemsMoved(ListMoveEvent event) {
                ValueListAdapter.this.itemsMoved(event);
            }

            @Override
            public void listCleared(ListClearEvent event) {
                ValueListAdapter.this.listCleared(event);
            }

            @Override
            public void listChanged(ListChangeEvent event) {
                ValueListAdapter.this.listChanged(event);
            }

            public String toString() {
                return "value list listener: " + Arrays.asList(ValueListAdapter.this.listNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.value).addListChangeListener(listName, this.valueListListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.value).removeListChangeListener(listName, this.valueListListener);
            ++n2;
        }
    }

    protected void itemsAdded(ListAddEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsRemoved(ListRemoveEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsReplaced(ListReplaceEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsMoved(ListMoveEvent event) {
        this.valueAspectChanged();
    }

    protected void listCleared(ListClearEvent event) {
        this.valueAspectChanged();
    }

    protected void listChanged(ListChangeEvent event) {
        this.valueAspectChanged();
    }
}

