/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.persistence.tools.utility.RunnableAdapter;
import org.eclipse.persistence.tools.utility.collection.SynchronizedQueue;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;

public final class AWTPropertyChangeListenerWrapper
implements PropertyChangeListener {
    private final PropertyChangeListener listener;
    private final SynchronizedQueue<PropertyChangeEvent> events = new SynchronizedQueue();

    public AWTPropertyChangeListenerWrapper(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        this.events.enqueue(event);
        if (this.isExecutingOnUIThread()) {
            this.forwardEvents();
        } else {
            this.executeOnEventQueue(new ForwardEventsRunnable());
        }
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void forwardEvents() {
        for (PropertyChangeEvent event : this.events.drain()) {
            this.listener.propertyChanged(event);
        }
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        @Override
        public void run() {
            AWTPropertyChangeListenerWrapper.this.forwardEvents();
        }
    }
}

