/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterator.ArrayListIterator;
import org.eclipse.persistence.tools.utility.iterator.SingleElementListIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationListIterator;

public class ReadOnlyCompositeListIterator<E>
implements ListIterator<E> {
    private final ListIterator<? extends ListIterator<? extends E>> iterators;
    private ListIterator<? extends E> nextIterator;
    private int nextIndex;

    public ReadOnlyCompositeListIterator(List<? extends List<? extends E>> lists) {
        this(new TransformationListIterator<List<? extends E>, ListIterator<? extends E>>(lists.listIterator()){

            @Override
            protected ListIterator<? extends E> transform(List<? extends E> list) {
                return list.listIterator();
            }
        });
    }

    public ReadOnlyCompositeListIterator(ListIterable<? extends ListIterable<? extends E>> iterables) {
        this(new TransformationListIterator<ListIterable<? extends E>, ListIterator<? extends E>>(iterables.iterator()){

            @Override
            protected ListIterator<? extends E> transform(ListIterable<? extends E> iterable) {
                return iterable.iterator();
            }
        });
    }

    public ReadOnlyCompositeListIterator(ListIterator<? extends ListIterator<? extends E>> iterators) {
        if (iterators == null) {
            throw new NullPointerException();
        }
        this.iterators = iterators;
        this.nextIndex = 0;
    }

    public ReadOnlyCompositeListIterator(E object, List<? extends E> list) {
        this((E)object, list.listIterator());
    }

    public ReadOnlyCompositeListIterator(E object, ListIterable<? extends E> iterable) {
        this((E)object, iterable.iterator());
    }

    public ReadOnlyCompositeListIterator(E object, ListIterator<? extends E> iterator) {
        this(new ListIterator[]{new SingleElementListIterator<E>(object), iterator});
    }

    public ReadOnlyCompositeListIterator(List<? extends E> list, E object) {
        this(list.listIterator(), (E)object);
    }

    public ReadOnlyCompositeListIterator(ListIterable<? extends E> iterable, E object) {
        this(iterable.iterator(), (E)object);
    }

    public ReadOnlyCompositeListIterator(ListIterator<? extends E> iterator, E object) {
        this(new ListIterator[]{iterator, new SingleElementListIterator<E>(object)});
    }

    public ReadOnlyCompositeListIterator(List<? extends E> ... lists) {
        this(Arrays.asList(lists));
    }

    public ReadOnlyCompositeListIterator(ListIterable<? extends E> ... iterables) {
        this((ListIterable<ListIterable<? extends E>>)new ArrayListIterable<ListIterable<? extends E>>(iterables));
    }

    public ReadOnlyCompositeListIterator(ListIterator<? extends E> ... iterators) {
        this((ListIterator<ListIterator<? extends E>>)new ArrayListIterator<ListIterator<? extends E>>(iterators));
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadNextIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        try {
            this.loadPreviousIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasPrevious();
    }

    @Override
    public E next() {
        this.loadNextIterator();
        E result = this.nextIterator.next();
        ++this.nextIndex;
        return result;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        this.loadPreviousIterator();
        E result = this.nextIterator.previous();
        --this.nextIndex;
        return result;
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    private void loadNextIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasNext() && this.iterators.hasNext()) {
            this.nextIterator = this.iterators.next();
        }
    }

    private void loadPreviousIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasPrevious() && this.iterators.hasPrevious()) {
            this.nextIterator = this.iterators.previous();
        }
    }

    private void checkNextIterator() {
        if (this.nextIterator == null) {
            this.nextIterator = this.iterators.next();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterators);
    }
}

