/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;

public class ArrayListIterator<E>
extends ArrayIterator<E>
implements ListIterator<E> {
    private final int min;

    public ArrayListIterator(E ... array) {
        this(array, 0);
    }

    public ArrayListIterator(E[] array, int start) {
        this(array, start, array.length);
    }

    public ArrayListIterator(E[] array, int start, int end) {
        super(array, start, end);
        this.min = start;
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor != this.min;
    }

    @Override
    public E previous() {
        if (this.hasPrevious()) {
            return (E)this.array[--this.cursor];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

