/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class TreeIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E> roots;
    private final Transformer<E, Iterator<? extends E>> transformer;

    public TreeIterable(Iterable<? extends E> roots, Transformer<E, Iterator<? extends E>> transformer) {
        if (roots == null || transformer == null) {
            throw new NullPointerException();
        }
        this.roots = roots;
        this.transformer = transformer;
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorTools.treeIterator(this.roots, this.transformer);
    }

    public String toString() {
        return ListTools.list(this).toString();
    }
}

