/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.reference.SynchronizedBoolean;

public class SynchronizingCommand
implements Command {
    private final Thread thread = Thread.currentThread();
    private final SynchronizedBoolean flag = new SynchronizedBoolean(false);
    private volatile boolean expired = false;
    private final Command command;

    public SynchronizingCommand() {
        this(Command.Null.instance());
    }

    public SynchronizingCommand(Command command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.command.execute();
        SynchronizedBoolean synchronizedBoolean = this.flag;
        synchronized (synchronizedBoolean) {
            if (this.expired) {
                this.expired = false;
                return;
            }
            this.flag.setTrue();
        }
        if (Thread.currentThread() != this.thread) {
            try {
                this.flag.waitUntilFalse();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitForExecution() throws InterruptedException {
        this.flag.waitUntilTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForExecution(long timeout) throws InterruptedException {
        SynchronizedBoolean synchronizedBoolean = this.flag;
        synchronized (synchronizedBoolean) {
            block4: {
                if (!this.flag.waitUntilTrue(timeout)) break block4;
                return true;
            }
            this.expired = true;
            return false;
        }
    }

    public void release() {
        this.flag.setFalse();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.flag);
    }
}

