/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;

public class ListenerList<L>
implements Serializable {
    private volatile transient L[] listeners;
    private static final long serialVersionUID = 1L;

    public ListenerList(Class<L> listenerClass) {
        this.listeners = this.buildListenerArray(listenerClass, 0);
    }

    public ListenerList(Class<L> listenerClass, L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners = this.buildListenerArray(listenerClass, 1);
        this.listeners[0] = listener;
    }

    private L[] buildListenerArray(Class<L> listenerClass, int length) {
        return (Object[])Array.newInstance(listenerClass, length);
    }

    public Iterable<L> getListeners() {
        return new ArrayIterable<L>(this.listeners);
    }

    public int size() {
        return this.listeners.length;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void add(L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (ArrayTools.contains(this.listeners, listener)) {
            throw new IllegalArgumentException("duplicate listener: " + listener);
        }
        this.listeners = ArrayTools.add(this.listeners, listener);
    }

    public synchronized void remove(L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int index = ArrayTools.indexOf(this.listeners, listener);
        if (index == -1) {
            throw new IllegalArgumentException("unregistered listener: " + listener);
        }
        this.listeners = ArrayTools.removeElementAtIndex(this.listeners, index);
    }

    public synchronized void clear() {
        this.listeners = ArrayTools.clear(this.listeners);
    }

    public Class<L> getListenerType() {
        return this.listeners.getClass().getComponentType();
    }

    public String toString() {
        return Arrays.toString(this.listeners);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Class<?> listenerClass = this.listeners.getClass().getComponentType();
        s.writeObject(listenerClass);
        L[] LArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            L listener = LArray[n2];
            if (listener instanceof Serializable) {
                s.writeObject(listener);
            }
            ++n2;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object o;
        s.defaultReadObject();
        Class listenerClass = (Class)s.readObject();
        this.listeners = this.buildListenerArray(listenerClass, 0);
        while ((o = s.readObject()) != null) {
            this.listeners = ArrayTools.add(this.listeners, o);
        }
    }
}

