/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.persistence.tools.utility.Classpath;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.io.FileTools;

public class JarManifestInterrogator {
    private final Defaults defaults;
    private final String jarFileName;
    private final Manifest manifest;
    private static final Attributes.Name RELEASE_DESIGNATION = new Attributes.Name("Release-Designation");
    private static final Attributes.Name LIBRARY_DESIGNATION = new Attributes.Name("Library-Designation");

    public JarManifestInterrogator(Class<?> javaClass, Defaults defaults) {
        if (defaults == null) {
            throw new NullPointerException();
        }
        this.defaults = defaults;
        this.jarFileName = this.buildJarFileName(javaClass);
        this.manifest = this.buildManifest();
    }

    protected String buildJarFileName(Class<?> javaClass) {
        File file;
        URL url = Classpath.convertToResource(javaClass);
        if (url.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        try {
            file = FileTools.buildFile(url);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        return file.getAbsolutePath().substring(0, file.getAbsolutePath().indexOf(33));
    }

    private Manifest buildManifest() {
        JarFile jarFile = this.buildJarFile();
        if (jarFile == null) {
            return new Manifest();
        }
        try {
            Manifest result = jarFile.getManifest();
            if (result == null) {
                return new Manifest();
            }
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JarFile buildJarFile() {
        if (this.jarFileName == null) {
            return null;
        }
        try {
            return new JarFile(this.jarFileName);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getMainAttributeValue(Attributes.Name name) {
        return this.getMainAttributeValue(name, null);
    }

    public String getMainAttributeValue(Attributes.Name name, String defaultValue) {
        String result = this.manifest.getMainAttributes().getValue(name);
        return StringTools.isNotBlank(result) ? result : defaultValue;
    }

    public boolean isDevelopmentMode() {
        return this.jarFileName == null;
    }

    public String getFullProductName() {
        return String.valueOf(this.getSpecificationVendor()) + ' ' + this.getProductName() + ' ' + this.getShortProductName();
    }

    public String getProductName() {
        return this.getMainAttributeValue(Attributes.Name.SPECIFICATION_TITLE, this.defaults.defaultSpecificationTitle());
    }

    public String getSpecificationVendor() {
        return this.getMainAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, this.defaults.defaultSpecificationVendor());
    }

    public String getShortProductName() {
        return this.getMainAttributeValue(LIBRARY_DESIGNATION, this.defaults.defaultLibraryDesignation());
    }

    public String getVersionNumber() {
        return this.getMainAttributeValue(Attributes.Name.SPECIFICATION_VERSION, this.defaults.defaultSpecificationVersion());
    }

    public String getBuildNumber() {
        if (this.isDevelopmentMode()) {
            return "<dev>";
        }
        String specVersion = this.getVersionNumber();
        String impVersion = this.getMainAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, this.defaults.defaultImplementationVersion());
        return impVersion.substring(specVersion.length() + 1);
    }

    public String getReleaseDesignation() {
        return this.getMainAttributeValue(RELEASE_DESIGNATION, this.defaults.defaultReleaseDesignation());
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.jarFileName);
    }

    public static interface Defaults {
        public String defaultSpecificationTitle();

        public String defaultSpecificationVendor();

        public String defaultReleaseDesignation();

        public String defaultLibraryDesignation();

        public String defaultSpecificationVersion();

        public String defaultImplementationVersion();
    }
}

