/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import org.eclipse.persistence.tools.utility.MultiThreadedExceptionHandler;

public class ExceptionHandlerThreadGroup
extends ThreadGroup {
    private final MultiThreadedExceptionHandler exceptionHandler;

    public ExceptionHandlerThreadGroup(String name, MultiThreadedExceptionHandler exceptionHandler) {
        super(name);
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandlerThreadGroup(ThreadGroup parent, String name, MultiThreadedExceptionHandler exceptionHandler) {
        super(parent, name);
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public synchronized void uncaughtException(Thread t, Throwable e) {
        this.exceptionHandler.handleException(t, e);
    }

    public MultiThreadedExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

