/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.platformsmodel;

import org.eclipse.persistence.tools.db.relational.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.node.AbstractNode;
import org.w3c.dom.Node;

public final class DatabaseType
extends AbstractNode {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private JDBCType jdbcType;
    public static final String JDBC_TYPE_PROPERTY = "jdbcType";
    private boolean allowsSize;
    public static final String ALLOWS_SIZE_PROPERTY = "allowsSize";
    private boolean requiresSize;
    public static final String REQUIRES_SIZE_PROPERTY = "requiresSize";
    private int initialSize;
    public static final String INITIAL_SIZE_PROPERTY = "initialSize";
    private boolean allowsSubSize;
    public static final String ALLOWS_SUB_SIZE_PROPERTY = "allowsSubSize";
    private boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";

    DatabaseType(DatabasePlatform platform, Node node) throws CorruptXMLException {
        super((org.eclipse.persistence.tools.utility.node.Node)platform);
        this.read(node);
    }

    DatabaseType(DatabasePlatform platform, String name) {
        super((org.eclipse.persistence.tools.utility.node.Node)platform);
        this.name = name;
        this.jdbcType = this.jdbcTypeRepository().getDefaultJDBCType();
    }

    protected void initialize() {
        super.initialize();
        this.allowsSize = true;
        this.requiresSize = false;
        this.initialSize = 0;
        this.allowsSubSize = false;
        this.allowsNull = true;
    }

    public DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.getPlatform().checkDatabaseTypeName(name);
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public void setJDBCType(JDBCType jdbcType) {
        if (jdbcType == null) {
            throw new NullPointerException();
        }
        JDBCType old = this.jdbcType;
        this.jdbcType = jdbcType;
        this.firePropertyChanged(JDBC_TYPE_PROPERTY, (Object)old, (Object)jdbcType);
    }

    public boolean allowsSize() {
        return this.allowsSize;
    }

    public void setAllowsSize(boolean allowsSize) {
        boolean old = this.allowsSize;
        this.allowsSize = allowsSize;
        this.firePropertyChanged(ALLOWS_SIZE_PROPERTY, old, allowsSize);
        if (!allowsSize) {
            this.setAllowsSubSize(false);
            this.setRequiresSize(false);
        }
    }

    public boolean requiresSize() {
        return this.requiresSize;
    }

    public void setRequiresSize(boolean requiresSize) {
        boolean old = this.requiresSize;
        this.requiresSize = requiresSize;
        this.firePropertyChanged(REQUIRES_SIZE_PROPERTY, old, requiresSize);
        if (requiresSize) {
            this.setAllowsSize(true);
        } else {
            this.setInitialSize(0);
        }
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("initial size must be greater than or equal to zero" + initialSize);
        }
        int old = this.initialSize;
        this.initialSize = initialSize;
        this.firePropertyChanged(INITIAL_SIZE_PROPERTY, old, initialSize);
        if (initialSize != 0) {
            this.setRequiresSize(true);
        }
    }

    public boolean allowsSubSize() {
        return this.allowsSubSize;
    }

    public void setAllowsSubSize(boolean allowsSubSize) {
        boolean old = this.allowsSubSize;
        this.allowsSubSize = allowsSubSize;
        this.firePropertyChanged(ALLOWS_SUB_SIZE_PROPERTY, old, allowsSubSize);
        if (allowsSubSize) {
            this.setAllowsSize(true);
        }
    }

    public boolean allowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean allowsNull) {
        boolean old = this.allowsNull;
        this.allowsNull = allowsNull;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, old, allowsNull);
    }

    public JavaTypeDeclaration javaTypeDeclaration() {
        return this.jdbcTypeRepository().javaTypeDeclarationFor(this.getJDBCType());
    }

    private DatabasePlatformRepository platformRepository() {
        return this.getPlatform().getRepository();
    }

    private JDBCTypeRepository jdbcTypeRepository() {
        return this.platformRepository().getJDBCTypeRepository();
    }

    private JDBCType jdbcTypeNamed(String jdbcTypeName) {
        return this.jdbcTypeRepository().jdbcTypeNamed(jdbcTypeName);
    }

    public Iterable<JDBCType> jdbcTypes() {
        return this.jdbcTypeRepository().jdbcTypes();
    }

    public int jdbcTypesSize() {
        return this.jdbcTypeRepository().jdbcTypesSize();
    }

    void cloneFrom(DatabaseType originalType) {
        this.setJDBCType(originalType.getJDBCType());
        this.setAllowsSize(originalType.allowsSize());
        this.setRequiresSize(originalType.requiresSize());
        this.setInitialSize(originalType.getInitialSize());
        this.setAllowsSubSize(originalType.allowsSubSize());
        this.setAllowsNull(originalType.allowsNull());
    }

    private void read(Node node) throws CorruptXMLException {
        if (node == null) {
            throw this.buildCorruptXMLException("missing node");
        }
        this.name = XMLTools.getChildTextContent((Node)node, (String)NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw this.buildCorruptXMLException("name is required");
        }
        String jdbcTypeName = XMLTools.getChildTextContent((Node)node, (String)"jdbc-type", null);
        try {
            this.jdbcType = this.jdbcTypeNamed(jdbcTypeName);
        }
        catch (IllegalArgumentException ex) {
            throw this.buildCorruptXMLException(ex);
        }
        this.allowsSize = XMLTools.getChildBooleanContent((Node)node, (String)"allows-size", (boolean)false);
        this.requiresSize = XMLTools.getChildBooleanContent((Node)node, (String)"requires-size", (boolean)false);
        if (!this.allowsSize && this.requiresSize) {
            throw this.buildCorruptXMLException("size cannot be required when it is not allowed");
        }
        this.initialSize = XMLTools.childIntContent((Node)node, (String)"initial-size", (int)0);
        if (!this.requiresSize && this.initialSize != 0) {
            throw this.buildCorruptXMLException("initial size cannot be specified when size is not required");
        }
        this.allowsSubSize = XMLTools.getChildBooleanContent((Node)node, (String)"allows-sub-size", (boolean)false);
        if (!this.allowsSize && this.allowsSubSize) {
            throw this.buildCorruptXMLException("sub-size cannot be allowed when size is not allowed");
        }
        this.allowsNull = XMLTools.getChildBooleanContent((Node)node, (String)"allows-null", (boolean)false);
    }

    private CorruptXMLException buildCorruptXMLException(String message) {
        return new CorruptXMLException(String.valueOf(message) + " (" + this.corruptXMLLocation() + ")");
    }

    private CorruptXMLException buildCorruptXMLException(Throwable t) {
        return new CorruptXMLException(this.corruptXMLLocation(), t);
    }

    private String corruptXMLLocation() {
        return String.valueOf(this.getPlatform().getName()) + ":" + this.name;
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode((Node)node, (String)NAME_PROPERTY, (String)this.name);
        XMLTools.addSimpleTextNode((Node)node, (String)"jdbc-type", (String)this.jdbcType.getName());
        XMLTools.addSimpleTextNode((Node)node, (String)"allows-size", (boolean)this.allowsSize, (boolean)false);
        XMLTools.addSimpleTextNode((Node)node, (String)"requires-size", (boolean)this.requiresSize, (boolean)false);
        XMLTools.addSimpleTextNode((Node)node, (String)"initial-size", (int)this.initialSize, (int)0);
        XMLTools.addSimpleTextNode((Node)node, (String)"allows-sub-size", (boolean)this.allowsSubSize, (boolean)false);
        XMLTools.addSimpleTextNode((Node)node, (String)"allows-null", (boolean)this.allowsNull, (boolean)false);
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }
}

