/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.platformsmodel;

import org.eclipse.persistence.tools.db.relational.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.node.AbstractNode;
import org.w3c.dom.Node;

abstract class AbstractJDBCTypeToJavaTypeDeclarationMapping
extends AbstractNode {
    JDBCType jdbcType;
    JavaTypeDeclaration javaTypeDeclaration;

    AbstractJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeRepository repository, Node node) throws CorruptXMLException {
        super((org.eclipse.persistence.tools.utility.node.Node)repository);
        this.read(node);
    }

    AbstractJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeRepository repository, JDBCType jdbcType, String javaClassName, int arrayDepth) {
        super((org.eclipse.persistence.tools.utility.node.Node)repository);
        if (jdbcType == null) {
            throw new NullPointerException();
        }
        this.jdbcType = jdbcType;
        this.javaTypeDeclaration = new JavaTypeDeclaration(this, javaClassName, arrayDepth);
    }

    private JDBCTypeRepository getJDBCTypeRepository() {
        return (JDBCTypeRepository)this.getParent();
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public JavaTypeDeclaration getJavaTypeDeclaration() {
        return this.javaTypeDeclaration;
    }

    private JDBCType jdbcTypeNamed(String jdbcTypeName) {
        return this.getJDBCTypeRepository().jdbcTypeNamed(jdbcTypeName);
    }

    private void read(Node node) throws CorruptXMLException {
        try {
            this.jdbcType = this.jdbcTypeNamed(XMLTools.getChildTextContent((Node)node, (String)"jdbc-type", null));
        }
        catch (IllegalArgumentException ex) {
            throw new CorruptXMLException(ex);
        }
        this.javaTypeDeclaration = new JavaTypeDeclaration((AbstractNode)this, XMLTools.getChild((Node)node, (String)"java-type-declaration"));
    }

    abstract void write(Node var1);

    void writeJDBCType(Node node) {
        XMLTools.addSimpleTextNode((Node)node, (String)"jdbc-type", (String)this.jdbcType.getName());
    }

    void writeJavaTypeDeclaration(Node node) {
        this.javaTypeDeclaration.write(node.appendChild(node.getOwnerDocument().createElement("java-type-declaration")));
    }

    public abstract void displayStringOn(StringBuffer var1);

    public String displayString() {
        StringBuffer sb = new StringBuffer();
        this.displayStringOn(sb);
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
        this.displayStringOn(sb);
    }
}

