/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.tools.db.relational.ELColumn;
import org.eclipse.persistence.tools.db.relational.ELColumnPair;
import org.eclipse.persistence.tools.db.relational.ELModel;
import org.eclipse.persistence.tools.db.relational.ELTable;
import org.eclipse.persistence.tools.db.relational.handles.MWHandle;
import org.eclipse.persistence.tools.db.relational.handles.MWTableHandle;
import org.eclipse.persistence.tools.db.relational.spi.ExternalForeignKey;
import org.eclipse.persistence.tools.db.relational.spi.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneIterable;
import org.eclipse.persistence.tools.utility.node.Node;

public final class ELReference
extends ELModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWTableHandle targetTableHandle;
    public static final String TARGET_TABLE_PROPERTY = "targetTable";
    private Collection<ELColumnPair> columnPairs;
    public static final String COLUMN_PAIRS_COLLECTION = "columnPairs";
    private volatile boolean onDatabase;
    public static final String ON_DATABASE_PROPERTY = "onDatabase";

    ELReference(ELTable parent, String name, ELTable targetTable) {
        super(parent);
        this.name = name;
        this.targetTableHandle.setTable(targetTable);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.targetTableHandle = new MWTableHandle(this, this.buildTargetTableScrubber());
        this.columnPairs = new Vector<ELColumnPair>();
        this.onDatabase = false;
    }

    public ELTable getSourceTable() {
        return (ELTable)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.getSourceTable().checkReferenceName(name);
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public ELTable getTargetTable() {
        return this.targetTableHandle.getTable();
    }

    public void setTargetTable(ELTable targetTable) {
        ELTable old = this.targetTableHandle.getTable();
        this.targetTableHandle.setTable(targetTable);
        this.firePropertyChanged(TARGET_TABLE_PROPERTY, old, targetTable);
        if (this.attributeValueHasChanged(old, targetTable)) {
            this.clearColumnPairs();
        }
    }

    public boolean isOnDatabase() {
        return this.onDatabase;
    }

    public void setOnDatabase(boolean onDatabase) {
        boolean old = this.onDatabase;
        this.onDatabase = onDatabase;
        this.firePropertyChanged(ON_DATABASE_PROPERTY, old, onDatabase);
    }

    public Iterable<ELColumnPair> columnPairs() {
        return new LiveCloneIterable<ELColumnPair>(this.columnPairs){

            protected void remove(ELColumnPair current) {
                ELReference.this.removeColumnPair(current);
            }
        };
    }

    public int columnPairsSize() {
        return this.columnPairs.size();
    }

    public ELColumnPair addColumnPair(ELColumn sourceColumn, ELColumn targetColumn) {
        if (sourceColumn.getTable() != this.getSourceTable()) {
            throw new IllegalArgumentException("invalid source column: " + sourceColumn);
        }
        if (targetColumn.getTable() != this.getTargetTable()) {
            throw new IllegalArgumentException("invalid target column: " + targetColumn);
        }
        return this.addColumnPair(new ELColumnPair(this, sourceColumn, targetColumn));
    }

    private ELColumnPair addColumnPair(ELColumnPair columnPair) {
        this.addItemToCollection(columnPair, this.columnPairs, COLUMN_PAIRS_COLLECTION);
        return columnPair;
    }

    public void removeColumnPair(ELColumnPair columnPair) {
        this.removeItemFromCollection(columnPair, this.columnPairs, COLUMN_PAIRS_COLLECTION);
    }

    public void removeColumnPairs(Iterator<ELColumnPair> pairs) {
        while (pairs.hasNext()) {
            this.removeColumnPair(pairs.next());
        }
    }

    public void removeColumnPairs(Collection<ELColumnPair> pairs) {
        this.removeColumnPairs(pairs.iterator());
    }

    private void clearColumnPairs() {
        this.clearCollection(this.columnPairs, COLUMN_PAIRS_COLLECTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELColumnPair columnPairNamed(String columnPairName) {
        Collection<ELColumnPair> collection = this.columnPairs;
        synchronized (collection) {
            for (ELColumnPair columnPair : this.columnPairs) {
                if (!columnPair.getName().equals(columnPairName)) continue;
                return columnPair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELColumnPair columnPairFor(ELColumn sourceColumn, ELColumn targetColumn) {
        Collection<ELColumnPair> collection = this.columnPairs;
        synchronized (collection) {
            for (ELColumnPair columnPair : this.columnPairs) {
                if (!columnPair.pairs(sourceColumn, targetColumn)) continue;
                return columnPair;
            }
        }
        return null;
    }

    public boolean isForeignKeyReference() {
        return !this.isPrimaryKeyReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPrimaryKeyReference() {
        HashBag sourcePrimaryKeys = CollectionTools.collection(this.getSourceTable().primaryKeyColumns());
        if (sourcePrimaryKeys.size() != this.columnPairs.size()) {
            return false;
        }
        HashBag targetPrimaryKeys = CollectionTools.collection(this.getTargetTable().primaryKeyColumns());
        if (targetPrimaryKeys.size() != this.columnPairs.size()) {
            return false;
        }
        Collection<ELColumnPair> collection = this.columnPairs;
        synchronized (collection) {
            ELColumnPair pair;
            Iterator<ELColumnPair> stream = this.columnPairs.iterator();
            do {
                if (!stream.hasNext()) {
                    return true;
                }
                pair = stream.next();
                if (sourcePrimaryKeys.remove(pair.getSourceColumn())) continue;
                return false;
            } while (targetPrimaryKeys.remove(pair.getTargetColumn()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.targetTableHandle);
        Collection<ELColumnPair> collection = this.columnPairs;
        synchronized (collection) {
            children.addAll(this.columnPairs);
        }
    }

    private MWHandle.NodeReferenceScrubber buildTargetTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                ELReference.this.setTargetTable(null);
            }

            public String toString() {
                return "MWReference.buildTargetTableScrubber()";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumnPairs(ExternalForeignKey externalForeignKey) {
        HashSet<ELColumnPair> removedColumnPairs;
        Collection<ELColumnPair> collection = this.columnPairs;
        synchronized (collection) {
            removedColumnPairs = new HashSet<ELColumnPair>(this.columnPairs);
        }
        ExternalForeignKeyColumnPair[] externalPairs = externalForeignKey.getColumnPairs();
        int i = externalPairs.length;
        while (i-- > 0) {
            this.refreshColumnPair(externalPairs[i], removedColumnPairs);
        }
        this.removeColumnPairs(removedColumnPairs);
    }

    private void refreshColumnPair(ExternalForeignKeyColumnPair externalPair, Collection removedColumnPairs) {
        Iterator stream = removedColumnPairs.iterator();
        while (stream.hasNext()) {
            if (!((ELColumnPair)stream.next()).matches(externalPair)) continue;
            stream.remove();
            return;
        }
        this.addColumnPair(this.sourceColumn(externalPair), this.targetColumn(externalPair));
    }

    ELColumn sourceColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getSourceTable().column(externalPair.getSourceColumn());
    }

    ELColumn targetColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getTargetTable().column(externalPair.getTargetColumn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchesColumnPairs(ExternalForeignKey externalForeignKey) {
        HashSet<ELColumnPair> columnPairsCopy;
        ExternalForeignKeyColumnPair[] externalPairs = externalForeignKey.getColumnPairs();
        int externalPairsLength = externalPairs.length;
        if (this.columnPairs.size() != externalPairsLength) {
            return false;
        }
        Collection<ELColumnPair> collection = this.columnPairs;
        synchronized (collection) {
            columnPairsCopy = new HashSet<ELColumnPair>(this.columnPairs);
        }
        int i = externalPairsLength;
        while (i-- > 0) {
            ExternalForeignKeyColumnPair externalPair = externalPairs[i];
            boolean match = false;
            Iterator stream = columnPairsCopy.iterator();
            while (stream.hasNext()) {
                if (!((ELColumnPair)stream.next()).matches(externalPair)) continue;
                stream.remove();
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
        sb.append(" : ");
        this.printTableNameOn(this.getSourceTable(), sb);
        sb.append("=>");
        this.printTableNameOn(this.getTargetTable(), sb);
    }

    private void printTableNameOn(ELTable table, StringBuffer sb) {
        sb.append(table == null ? "null" : table.getName());
    }
}

