/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;

public class QuerySQLTracker
extends DefaultSessionLog {
    private SessionLog originalLog;
    private SessionEventListener listener;
    private List sqlStatements = new ArrayList();
    private List queries = new ArrayList();

    public QuerySQLTracker(Session session) {
        this.originalLog = session.getSessionLog();
        this.setLevel(1);
        this.setSession(session);
        this.setWriter(this.originalLog.getWriter());
        this.getSession().setSessionLog((SessionLog)this);
        this.listener = this.buildListener();
        this.getSession().getEventManager().addListener(this.listener);
    }

    public void remove() {
        this.getSession().setSessionLog(this.originalLog);
        this.getSession().getEventManager().removeListener(this.listener);
    }

    public synchronized void log(SessionLogEntry entry) {
        if (entry.getNameSpace() != null && entry.getNameSpace().equalsIgnoreCase("sql")) {
            this.getSqlStatements().add(entry.getMessage());
        }
        if (!this.originalLog.shouldLog(entry.getLevel())) {
            return;
        }
        super.log(entry);
    }

    private SessionEventListener buildListener() {
        return new SessionEventAdapter(){
            private QuerySQLTracker tracker;
            {
                this.tracker = QuerySQLTracker.this;
            }

            public void preExecuteQuery(SessionEvent event) {
                this.tracker.getQueries().add(event.getQuery());
            }
        };
    }

    public SessionEventListener getListener() {
        return this.listener;
    }

    public List getSqlStatements() {
        return this.sqlStatements;
    }

    public List getQueries() {
        return this.queries;
    }
}

