/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class StoredProcedureTest
extends TestCase {
    DatabaseRecord row;
    boolean shouldBindAllParameters;

    public StoredProcedureTest() {
        this(true);
    }

    public StoredProcedureTest(boolean shouldBindAllParameters) {
        this.shouldBindAllParameters = shouldBindAllParameters;
        this.setName(this.getName() + " bind = " + shouldBindAllParameters);
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test can only be run in Oracle");
        }
    }

    public void test() {
        Integer id = new Integer(12);
        String name = "James";
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("StoredProcedure_InOutput");
        call.addNamedInOutputArgument("P_EMP_ID");
        call.addNamedInOutputArgument("P_F_NAME");
        DataReadQuery query = new DataReadQuery();
        query.setShouldBindAllParameters(this.shouldBindAllParameters);
        query.bindAllParameters();
        query.setCall((Call)call);
        query.addArgument("P_EMP_ID");
        query.addArgument("P_F_NAME");
        Vector<Object> args = new Vector<Object>(2);
        args.addElement(id);
        args.addElement(name);
        this.row = (DatabaseRecord)((Vector)this.getSession().executeQuery((DatabaseQuery)query, args)).firstElement();
    }

    public void verify() {
        if (((Number)this.row.get("P_EMP_ID")).intValue() != 12) {
            throw new TestErrorException("Invalid Field");
        }
        if (!this.row.get("P_F_NAME").equals("James")) {
            throw new TestErrorException("Invalid Field");
        }
    }
}

