/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.Assassin;
import org.eclipse.persistence.testing.models.jpa.inheritance.Bomb;
import org.eclipse.persistence.testing.models.jpa.inheritance.ContractedPersonel;
import org.eclipse.persistence.testing.models.jpa.inheritance.DirectElimination;
import org.eclipse.persistence.testing.models.jpa.inheritance.DirectWeapon;
import org.eclipse.persistence.testing.models.jpa.inheritance.Elimination;
import org.eclipse.persistence.testing.models.jpa.inheritance.EliminationPK;
import org.eclipse.persistence.testing.models.jpa.inheritance.Gun;
import org.eclipse.persistence.testing.models.jpa.inheritance.IndirectElimination;
import org.eclipse.persistence.testing.models.jpa.inheritance.IndirectWeapon;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.SocialClub;
import org.eclipse.persistence.testing.models.jpa.inheritance.SpecialAssassin;
import org.eclipse.persistence.testing.models.jpa.inheritance.Weapon;

public class TablePerClassInheritanceJUnitTest
extends JUnitTestCase {
    private static Integer assassinId;
    private static Integer specialAssassinId;
    private static Integer socialClub1Id;
    private static Integer socialClub2Id;
    private static Integer socialClub3Id;
    private static Integer gunSerialNumber;
    private static EliminationPK directEliminationPK;
    private static EliminationPK indirectEliminationPK;

    public TablePerClassInheritanceJUnitTest() {
    }

    public TablePerClassInheritanceJUnitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TablePerClassInheritanceJUnitTestSuite");
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testSetup"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testCreateAssassinWithGun"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateAssassinWithGun"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateGunToAssassin"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testAddDirectElimination"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateDirectElimination"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testAddIndirectElimination"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateIndirectElimination"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateAssassinWithBombAndEliminations"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testNamedQueryFindAllWeapons"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testNamedQueryFindAllWeaponsWhereDescriptionContainsSniper"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testCreateNewSocialClubsWithMembers"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testBatchFindAllWeapons"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateSocialClub1Members"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateSocialClub2Members"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testValidateSocialClub3Members"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testAssassinOptimisticLocking"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testSpecialAssassinOptimisticLocking"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testAssassinOptimisticLockingUsingEntityManagerAPI"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testGunOptimisticLocking"));
        suite.addTest((Test)new TablePerClassInheritanceJUnitTest("testUpdateAllQuery"));
        return suite;
    }

    public void testSetup() {
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAssassinWithGun() {
        EntityManager em = this.createEntityManager();
        Assassin assassin = null;
        try {
            this.beginTransaction(em);
            assassin = new Assassin();
            assassin.setName("Assassin1");
            assassin.getNicknames().add("Bonny");
            assassin.getNicknames().add("Clyde");
            Gun gun = new Gun();
            gun.setCaliber(new Integer(50));
            gun.setDescription("Sniper rifle");
            gun.setModel("9-112");
            assassin.setWeapon((Weapon)gun);
            em.persist((Object)assassin);
            assassinId = assassin.getId();
            gunSerialNumber = gun.getSerialNumber();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TablePerClassInheritanceJUnitTest.fail((String)("Error persisting new assassin: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        this.verifyObjectInCacheAndDatabase(assassin);
    }

    public void testValidateAssassinWithGun() {
        EntityManager em = this.createEntityManager();
        Assassin assassin = (Assassin)em.find(Assassin.class, (Object)assassinId);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The assassin could not be read back.", (Object)assassin);
        Weapon weapon = assassin.getWeapon();
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The assassin's weapon was null", (Object)weapon);
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The assassin's weapon was not a direct weapon", (boolean)weapon.isDirectWeapon());
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The assassin's weapon was not a gun", (boolean)((DirectWeapon)weapon).isGun());
        this.closeEntityManager(em);
    }

    public void testValidateGunToAssassin() {
        EntityManager em = this.createEntityManager();
        Gun gun = (Gun)em.find(Gun.class, (Object)gunSerialNumber);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The gun could not be read back.", (Object)gun);
        Assassin assassin = gun.getAssassin();
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The gun's assassin was null", (Object)assassin);
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The gun is currently not assigned to the correct assassin", (boolean)assassin.getId().equals(assassinId));
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddDirectElimination() {
        EntityManager em = this.createEntityManager();
        DirectElimination directElimination = null;
        try {
            this.beginTransaction(em);
            Assassin assassin = (Assassin)em.find(Assassin.class, (Object)assassinId);
            directElimination = new DirectElimination();
            directElimination.setId(Integer.valueOf(new Long(System.currentTimeMillis()).intValue()));
            directElimination.setName("Joe Smuck");
            directElimination.setDescription("Because he has a big mouth");
            directElimination.setAssassin(assassin);
            em.persist((Object)directElimination);
            directEliminationPK = directElimination.getPK();
            assassin.getEliminations().add(directElimination);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            TablePerClassInheritanceJUnitTest.fail((String)("Error adding new direct elimination: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        this.verifyObjectInCacheAndDatabase(directElimination);
    }

    public void testValidateDirectElimination() {
        EntityManager em = this.createEntityManager();
        Elimination directElimination = (Elimination)em.find(Elimination.class, (Object)directEliminationPK);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The direct elimination could not be read back.", (Object)directElimination);
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The elimination was not a direct elimination", (boolean)directElimination.isDirectElimination());
        DirectWeapon weapon = ((DirectElimination)directElimination).getDirectWeapon();
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The direct elimination's weapon was null", (Object)weapon);
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The direct elimination's weapon was not a direct weapon", (boolean)weapon.isDirectWeapon());
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The direct elimination's weapon was not a gun", (boolean)weapon.isGun());
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddIndirectElimination() {
        EntityManager em = this.createEntityManager();
        IndirectElimination indirectElimination = null;
        try {
            this.beginTransaction(em);
            Assassin assassin = (Assassin)em.find(Assassin.class, (Object)assassinId);
            Bomb bomb = new Bomb();
            bomb.setBombType(Bomb.BOMBTYPE.DIRTY);
            bomb.setDescription("Nasty blasty");
            em.persist((Object)bomb);
            assassin.setWeapon((Weapon)bomb);
            indirectElimination = new IndirectElimination();
            indirectElimination.setId(Integer.valueOf(new Long(System.currentTimeMillis()).intValue()));
            indirectElimination.setName("Jill Smuck");
            indirectElimination.setDescription("Because she has a big mouth");
            indirectElimination.setAssassin(assassin);
            em.persist((Object)indirectElimination);
            indirectEliminationPK = indirectElimination.getPK();
            assassin.getEliminations().add(indirectElimination);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            TablePerClassInheritanceJUnitTest.fail((String)("Error adding new indirect elimination: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        this.verifyObjectInCacheAndDatabase(indirectElimination);
    }

    public void testValidateIndirectElimination() {
        EntityManager em = this.createEntityManager();
        Elimination indirectElimination = (Elimination)em.find(Elimination.class, (Object)indirectEliminationPK);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The indirect elimination could not be read back.", (Object)indirectElimination);
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The elimination was not an idirect elimination", (boolean)indirectElimination.isIndirectElimination());
        IndirectWeapon weapon = ((IndirectElimination)indirectElimination).getIndirectWeapon();
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The indirect elimination's weapon was null", (Object)weapon);
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The indirect elimination's weapon was not an idirect weapon", (boolean)weapon.isIndirectWeapon());
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The indirect elimination's weapon was not a bomb", (boolean)weapon.isBomb());
        this.closeEntityManager(em);
    }

    public void testValidateAssassinWithBombAndEliminations() {
        EntityManager em = this.createEntityManager();
        Assassin assassin = (Assassin)em.find(Assassin.class, (Object)assassinId);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The assassin could not be read back.", (Object)assassin);
        assassin.getEliminations();
        TablePerClassInheritanceJUnitTest.assertFalse((String)"The assassin didn't have any eliminations", (boolean)assassin.getEliminations().isEmpty());
        Weapon weapon = assassin.getWeapon();
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The assassin's weapon was null", (Object)weapon);
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The assassin's weapon was not an indirect weapon", (boolean)weapon.isIndirectWeapon());
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The assassin's weapon was not a bomb", (boolean)((IndirectWeapon)weapon).isBomb());
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedQueryFindAllWeapons() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createNamedQuery("findAllWeapons");
            List weapons = query.getResultList();
            TablePerClassInheritanceJUnitTest.assertFalse((String)"No weapons were returned", (boolean)weapons.isEmpty());
            TablePerClassInheritanceJUnitTest.assertTrue((String)"Expected weapon count of 2 not returned", (weapons.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFindAllWeapons() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select w from Weapon w");
            query.setHint("eclipselink.batch", (Object)"w.assassin");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            List weapons = query.getResultList();
            for (Weapon weapon : weapons) {
                weapon.getAssassin();
            }
            TablePerClassInheritanceJUnitTest.assertFalse((String)"No weapons were returned", (boolean)weapons.isEmpty());
            TablePerClassInheritanceJUnitTest.assertTrue((String)"Expected weapon count of 2 not returned", (weapons.size() == 2 ? 1 : 0) != 0);
            this.clearCache();
            em.clear();
            query = em.createQuery("Select w from Weapon w");
            query.setHint("eclipselink.batch", (Object)"w.assassin");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.EXISTS);
            weapons = query.getResultList();
            for (Weapon weapon : weapons) {
                weapon.getAssassin();
            }
            TablePerClassInheritanceJUnitTest.assertFalse((String)"No weapons were returned", (boolean)weapons.isEmpty());
            TablePerClassInheritanceJUnitTest.assertTrue((String)"Expected weapon count of 2 not returned", (weapons.size() == 2 ? 1 : 0) != 0);
            this.clearCache();
            em.clear();
            query = em.createQuery("Select w from Weapon w");
            query.setHint("eclipselink.batch", (Object)"w.assassin");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.JOIN);
            weapons = query.getResultList();
            for (Weapon weapon : weapons) {
                weapon.getAssassin();
            }
            TablePerClassInheritanceJUnitTest.assertFalse((String)"No weapons were returned", (boolean)weapons.isEmpty());
            TablePerClassInheritanceJUnitTest.assertTrue((String)"Expected weapon count of 2 not returned", (weapons.size() == 2 ? 1 : 0) != 0);
            this.clearCache();
            em.clear();
            query = em.createQuery("Select s from SocialClub s");
            query.setHint("eclipselink.batch", (Object)"s.members");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            List clubs = query.getResultList();
            for (SocialClub club : clubs) {
                club.getMembers().size();
            }
            this.clearCache();
            em.clear();
            query = em.createQuery("Select s from SocialClub s");
            query.setHint("eclipselink.batch", (Object)"s.members");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.JOIN);
            clubs = query.getResultList();
            for (SocialClub club : clubs) {
                club.getMembers().size();
            }
            this.clearCache();
            em.clear();
            query = em.createQuery("Select s from SocialClub s");
            query.setHint("eclipselink.batch", (Object)"s.members");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.EXISTS);
            clubs = query.getResultList();
            for (SocialClub club : clubs) {
                club.getMembers().size();
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedQueryFindAllWeaponsWhereDescriptionContainsSniper() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createNamedQuery("findAllWeaponsContainingDescription");
            query.setParameter("description", (Object)"Sniper%");
            List weapons = query.getResultList();
            TablePerClassInheritanceJUnitTest.assertFalse((String)"No weapons were returned", (boolean)weapons.isEmpty());
            TablePerClassInheritanceJUnitTest.assertTrue((String)"Expected weapon count of 1 not returned", (weapons.size() == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            TablePerClassInheritanceJUnitTest.fail((String)("Error issuing find all weapons query: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewSocialClubsWithMembers() {
        EntityManager em = this.createEntityManager();
        SocialClub socialClub1 = null;
        SocialClub socialClub2 = null;
        SocialClub socialClub3 = null;
        try {
            this.beginTransaction(em);
            socialClub1 = new SocialClub();
            socialClub1.setName("Jimmy's my name and killing is my game!");
            em.persist((Object)socialClub1);
            socialClub1Id = socialClub1.getId();
            socialClub2 = new SocialClub();
            socialClub2.setName("Sharp shooting");
            em.persist((Object)socialClub2);
            socialClub2Id = socialClub2.getId();
            socialClub3 = new SocialClub();
            socialClub3.setName("Precision explosions");
            em.persist((Object)socialClub3);
            socialClub3Id = socialClub3.getId();
            ContractedPersonel contractedPersonel = new ContractedPersonel();
            contractedPersonel.setName("Hired Goon");
            em.persist((Object)contractedPersonel);
            SpecialAssassin specialAssassin = new SpecialAssassin();
            specialAssassin.setName("IED Expert");
            em.persist((Object)specialAssassin);
            specialAssassinId = specialAssassin.getId();
            Assassin assassin = (Assassin)em.find(Assassin.class, (Object)assassinId);
            socialClub1.addMember((ContractedPersonel)assassin);
            socialClub1.addMember(contractedPersonel);
            socialClub1.addMember((ContractedPersonel)specialAssassin);
            socialClub2.addMember((ContractedPersonel)assassin);
            socialClub2.addMember(contractedPersonel);
            socialClub3.addMember(contractedPersonel);
            socialClub3.addMember((ContractedPersonel)specialAssassin);
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
        this.verifyObjectInCacheAndDatabase(socialClub1);
        this.verifyObjectInCacheAndDatabase(socialClub2);
        this.verifyObjectInCacheAndDatabase(socialClub3);
    }

    public void testValidateSocialClub1Members() {
        EntityManager em = this.createEntityManager();
        SocialClub socialClub1 = (SocialClub)this.createEntityManager().find(SocialClub.class, (Object)socialClub1Id);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The social club 1 could not be read back.", (Object)socialClub1);
        TablePerClassInheritanceJUnitTest.assertFalse((String)"The member list was empty", (boolean)socialClub1.getMembers().isEmpty());
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The member count was not the expected 3", (socialClub1.getMembers().size() == 3 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testValidateSocialClub2Members() {
        EntityManager em = this.createEntityManager();
        SocialClub socialClub2 = (SocialClub)this.createEntityManager().find(SocialClub.class, (Object)socialClub2Id);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The social club 1 could not be read back.", (Object)socialClub2);
        TablePerClassInheritanceJUnitTest.assertFalse((String)"The member list was empty", (boolean)socialClub2.getMembers().isEmpty());
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The member count was not the expected 2", (socialClub2.getMembers().size() == 2 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testValidateSocialClub3Members() {
        EntityManager em = this.createEntityManager();
        SocialClub socialClub3 = (SocialClub)this.createEntityManager().find(SocialClub.class, (Object)socialClub3Id);
        TablePerClassInheritanceJUnitTest.assertNotNull((String)"The social club 1 could not be read back.", (Object)socialClub3);
        TablePerClassInheritanceJUnitTest.assertFalse((String)"The member list was empty", (boolean)socialClub3.getMembers().isEmpty());
        TablePerClassInheritanceJUnitTest.assertTrue((String)"The member count was not the expected 2", (socialClub3.getMembers().size() == 2 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimisticLockTestOnAssassin(Integer id) {
        if (!TablePerClassInheritanceJUnitTest.isOnServer()) {
            RuntimeException caughtException;
            block10: {
                EntityManager em1 = this.createEntityManager();
                EntityManager em2 = this.createEntityManager();
                em1.getTransaction().begin();
                em2.getTransaction().begin();
                caughtException = null;
                try {
                    Assassin assassin1 = (Assassin)em1.find(Assassin.class, (Object)id);
                    Assassin assassin2 = (Assassin)em2.find(Assassin.class, (Object)id);
                    assassin1.setName("Geezer");
                    assassin2.setName("Guyzer");
                    em1.getTransaction().commit();
                    em2.getTransaction().commit();
                    em1.close();
                    em2.close();
                }
                catch (RuntimeException e) {
                    if (em1.getTransaction().isActive()) {
                        em1.getTransaction().rollback();
                    }
                    if (em2.getTransaction().isActive()) {
                        em2.getTransaction().rollback();
                    }
                    if (e.getCause() instanceof OptimisticLockException) {
                        caughtException = e;
                        break block10;
                    }
                    throw e;
                }
                finally {
                    em1.close();
                    em2.close();
                }
            }
            if (caughtException == null) {
                TablePerClassInheritanceJUnitTest.fail((String)"Optimistic lock exception was not thrown.");
            }
        }
    }

    public void testAssassinOptimisticLocking() {
        this.optimisticLockTestOnAssassin(assassinId);
    }

    public void testSpecialAssassinOptimisticLocking() {
        this.optimisticLockTestOnAssassin(specialAssassinId);
    }

    public void testAssassinOptimisticLockingUsingEntityManagerAPI() {
        if (!TablePerClassInheritanceJUnitTest.isOnServer()) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            Assassin assassin = null;
            try {
                assassin = new Assassin();
                assassin.setName("OptLockAssassin");
                em.persist((Object)assassin);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            EntityManager em2 = this.createEntityManager();
            PersistenceException optimisticLockException = null;
            this.beginTransaction(em);
            try {
                assassin = (Assassin)em.find(Assassin.class, (Object)assassin.getId());
                em.lock((Object)assassin, LockModeType.WRITE);
                this.beginTransaction(em2);
                try {
                    Assassin assassin2 = (Assassin)em2.find(Assassin.class, (Object)assassin.getId());
                    assassin2.setName("OptLockAssassin2");
                    this.commitTransaction(em2);
                    em2.close();
                }
                catch (RuntimeException ex) {
                    if (this.isTransactionActive(em2)) {
                        this.rollbackTransaction(em2);
                    }
                    this.closeEntityManager(em2);
                    throw ex;
                }
                try {
                    em.flush();
                }
                catch (PersistenceException exception) {
                    if (exception instanceof OptimisticLockException) {
                        optimisticLockException = exception;
                    }
                    throw exception;
                }
                this.rollbackTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            try {
                this.beginTransaction(em);
                assassin = (Assassin)em.find(Assassin.class, (Object)assassin.getId());
                em.remove((Object)assassin);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            TablePerClassInheritanceJUnitTest.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, OPTIMISTIC) is used.", (optimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGunOptimisticLocking() {
        if (!TablePerClassInheritanceJUnitTest.isOnServer()) {
            RuntimeException caughtException;
            block10: {
                EntityManager em1 = this.createEntityManager();
                EntityManager em2 = this.createEntityManager();
                em1.getTransaction().begin();
                em2.getTransaction().begin();
                caughtException = null;
                try {
                    Gun gun1 = (Gun)em1.find(Gun.class, (Object)gunSerialNumber);
                    Gun gun2 = (Gun)em2.find(Gun.class, (Object)gunSerialNumber);
                    gun1.setCaliber(new Integer(12));
                    gun2.setCaliber(new Integer(22));
                    em1.getTransaction().commit();
                    em2.getTransaction().commit();
                    em1.close();
                    em2.close();
                }
                catch (RuntimeException e) {
                    if (em1.getTransaction().isActive()) {
                        em1.getTransaction().rollback();
                    }
                    if (em2.getTransaction().isActive()) {
                        em2.getTransaction().rollback();
                    }
                    if (e.getCause() instanceof OptimisticLockException) {
                        caughtException = e;
                        break block10;
                    }
                    throw e;
                }
                finally {
                    em1.close();
                    em2.close();
                }
            }
            if (caughtException == null) {
                TablePerClassInheritanceJUnitTest.fail((String)"Optimistic lock exception was not thrown.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateAllQuery() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpressionBuilder eb = new ExpressionBuilder();
            UpdateAllQuery updateQuery = new UpdateAllQuery(Assassin.class);
            updateQuery.addUpdate(eb.get("name"), (Object)"Generic Assassin Name");
            ((JpaEntityManager)em.getDelegate()).getServerSession().executeQuery((DatabaseQuery)updateQuery);
            Assassin assassin = (Assassin)em.find(ContractedPersonel.class, (Object)assassinId);
            em.refresh((Object)assassin);
            this.commitTransaction(em);
            TablePerClassInheritanceJUnitTest.assertTrue((String)"Update all did not work", (boolean)assassin.getName().equals("Generic Assassin Name"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TablePerClassInheritanceJUnitTest.fail((String)("Error issuing update all contracted personel query: " + e.getMessage()));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

