/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class BatchWritingWithSessionBrokerTest
extends AutoVerifyTestCase {
    protected boolean doesUseBatchWriting;
    protected static int NUM_INSERTS = 5;

    public BatchWritingWithSessionBrokerTest() {
        this.setDescription("Tests batch writing in conjunction with a unit of work, a session broker and a client/server session.");
    }

    public void reset() {
        ((SessionBroker)this.getSession()).getSessionForName("broker1").getLogin().dontUseBatchWriting();
        this.getAbstractSession().rollbackTransaction();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        ((SessionBroker)this.getSession()).getSessionForName("broker1").getLogin().useBatchWriting();
    }

    public void test() {
        UnitOfWorkImpl uow = ((SessionBroker)this.getSession()).acquireUnitOfWork();
        for (int i = 0; i < NUM_INSERTS; ++i) {
            uow.registerObject((Object)new Employee());
        }
        uow.commit();
    }

    public void verify() {
        int size = this.getSession().readAllObjects(Employee.class).size();
        if (size != 17) {
            throw new TestErrorException("Batch inserted objects not found, expects 17 objects found:" + size);
        }
    }
}

