/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.merge.advanced;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Employee;

@Entity(name="AnnMergeAddress")
@Table(name="CMP3_ANN_MERGE_ADDRESS")
@NamedNativeQuery(name="ann_merge_findAllSQLAddresses", query="select * from CMP3_ANN_MERGE_ADDRESS", resultClass=Address.class)
@NamedQuery(name="ann_merge_findAllAddressesByPostalCode", query="SELECT OBJECT(address) FROM Address address WHERE address.postalCode = :postalcode")
@TableGenerator(name="ANN_MERGE_ADDRESS_SEQUENCE_GENERATOR", table="ANN_MERGE_ADDRESS_SEQ", pkColumnValue="ANN_MERGE_ADDRESS_SEQ", allocationSize=25)
public class Address
implements Serializable {
    private Integer id;
    private String street;
    private String city;
    private String province;
    private String postalCode;
    private String country;
    private Collection<Employee> employees;

    public Address() {
        this.city = "";
        this.province = "";
        this.postalCode = "";
        this.street = "";
        this.country = "";
        this.employees = new Vector<Employee>();
    }

    public Address(String street, String city, String province, String country, String postalCode) {
        this.street = street;
        this.city = city;
        this.province = province;
        this.country = country;
        this.postalCode = postalCode;
        this.employees = new Vector<Employee>();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ANN_MERGE_ADDRESS_SEQUENCE_GENERATOR")
    @Column(name="ANN_MERGE_ADDRESS_ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    @Column(name="ANN_MERGE_P_CODE")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="address")
    public Collection<Employee> getEmployees() {
        return this.employees;
    }

    public void setEmployees(Collection<Employee> employees) {
        this.employees = employees;
    }
}

