/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import java.math.BigDecimal;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChangesFailed_StatementCountTestCase
extends AutoVerifyTestCase {
    public BigDecimal id = null;
    public int writeStatementsCount = 0;
    public int readStatementsCount = 0;
    public int storedprocedureStatementsCount = 0;
    public int originalReadStatementsCount = 0;
    public int originalWriteStatementsCount = 0;
    public int originalStoredProcedureStatementsCount = 0;

    public void setup() {
        this.id = new BigDecimal(999);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = new Employee();
        employee = (Employee)uow.registerObject((Object)employee);
        employee.setId(this.id);
        employee.setFirstName("foo");
        uow.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalWriteStatementsCount = ((DatasourceAccessor)uow.getParent().getAccessor()).writeStatementsCount;
        this.originalReadStatementsCount = ((DatasourceAccessor)uow.getParent().getAccessor()).readStatementsCount;
        this.originalStoredProcedureStatementsCount = ((DatasourceAccessor)uow.getParent().getAccessor()).storedProcedureStatementsCount;
        try {
            Employee employee = new Employee();
            employee = (Employee)uow.registerNewObject((Object)employee);
            employee.setId(this.id);
            employee.setFirstName("foo-modified");
            try {
                uow.writeChanges();
            }
            catch (Exception e) {
                if (uow.getProperties() != null) {
                    if (uow.getProperties().get("Read_Statements_Count_Property") == null) {
                        throw new TestErrorException("The read statments count property should be set if writechanges get failed.");
                    }
                    if (uow.getProperties().get("Write_Statements_Count_Property") == null) {
                        throw new TestErrorException("The write statments count property should be set if writechanges get failed.");
                    }
                    this.writeStatementsCount = (Integer)uow.getProperties().get("Write_Statements_Count_Property");
                    if (uow.getProperties().get("StoredProcedure_Statements_Count_Property") == null) {
                        throw new TestErrorException("The store procedure statments count property should be set if writechanges get failed.");
                    }
                }
            }
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        if (this.writeStatementsCount - this.originalWriteStatementsCount != 0) {
            throw new TestErrorException("The desirable number of write statement being executed should be 0, it however has more than 0 statement being executed:" + (this.writeStatementsCount - this.originalWriteStatementsCount));
        }
    }

    public void reset() {
        if (this.id == null) {
            return;
        }
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.id);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, expression);
        Employee employee = (Employee)uow.executeQuery((DatabaseQuery)query);
        uow.deleteObject((Object)employee);
        uow.commit();
    }

    protected void resetVerify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.id);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, expression);
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        this.id = null;
        if (employee != null) {
            throw new TestErrorException("Employee not removed after the test.");
        }
    }
}

