/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.inmemory.QueryCacheHitEnabledAndDescriptorDisabledTest;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class QueryCacheHitEnabledAndDescriptorDisabledOnRemoteTest
extends QueryCacheHitEnabledAndDescriptorDisabledTest {
    protected boolean orgDisableCacheHitsOnRemote;
    protected ClassDescriptor serverDescriptor;
    protected boolean orgServerDisableCacheHits;
    protected ServerSession serverSession;

    public QueryCacheHitEnabledAndDescriptorDisabledOnRemoteTest() {
        this.setDescription("Test when cache hit is enabled in query and disabled descriptor, cache is checked");
    }

    @Override
    protected void setup() {
        super.setup();
        this.orgDisableCacheHitsOnRemote = this.descriptor.shouldDisableCacheHitsOnRemote();
        this.descriptor.setShouldDisableCacheHitsOnRemote(true);
        this.serverSession = ((ClientSession)RemoteModel.getServerSession()).getParent();
        this.serverDescriptor = this.serverSession.getDescriptor(Employee.class);
        this.orgServerDisableCacheHits = this.serverDescriptor.shouldDisableCacheHits();
        this.serverDescriptor.setShouldDisableCacheHits(true);
        this.oldLog = this.serverSession.getSessionLog();
        this.tempStream = new StringWriter();
        this.serverSession.setLog((Writer)this.tempStream);
        this.serverSession.setLogLevel(3);
    }

    @Override
    public void reset() {
        this.descriptor.setShouldDisableCacheHitsOnRemote(this.orgDisableCacheHitsOnRemote);
        this.serverDescriptor.setShouldDisableCacheHits(this.orgServerDisableCacheHits);
        this.serverSession.setSessionLog(this.oldLog);
        super.reset();
    }
}

