/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.tests.remote.Master;
import org.eclipse.persistence.testing.tests.remote.MasterSlaveProject;
import org.eclipse.persistence.testing.tests.remote.MasterSlaveTableCreator;
import org.eclipse.persistence.testing.tests.remote.Slave;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class MasterSlaveSystem
extends TestSystem {
    public MasterSlaveSystem() {
        this.project = new MasterSlaveProject();
    }

    public void addDescriptors(DatabaseSession session) {
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        MasterSlaveTableCreator tableCreator = new MasterSlaveTableCreator();
        tableCreator.replaceTables(session);
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        UnitOfWork uow = session.acquireUnitOfWork();
        Master master = this.masterExample1();
        manager.registerObject((Object)master, "master1");
        master = (Master)uow.registerObject((Object)master);
        master.addSlave(this.slaveExample1());
        master.addSlave(this.slaveExample2());
        master.addSlave(this.slaveExample3());
        master.addSlave(this.slaveExample4());
        master = this.masterExample2();
        manager.registerObject((Object)master, "master2");
        master = (Master)uow.registerObject((Object)master);
        master.addSlave(this.slaveExample5());
        master.addSlave(this.slaveExample6());
        uow.commit();
    }

    public Master masterExample1() {
        Master master = new Master();
        master.setId(1);
        return master;
    }

    public Master masterExample2() {
        Master master = new Master();
        master.setId(2);
        return master;
    }

    public Slave slaveExample1() {
        Slave slave = new Slave();
        slave.setId(1);
        return slave;
    }

    public Slave slaveExample2() {
        Slave slave = new Slave();
        slave.setId(2);
        return slave;
    }

    public Slave slaveExample3() {
        Slave slave = new Slave();
        slave.setId(3);
        return slave;
    }

    public Slave slaveExample4() {
        Slave slave = new Slave();
        slave.setId(4);
        return slave;
    }

    public Slave slaveExample5() {
        Slave slave = new Slave();
        slave.setId(5);
        return slave;
    }

    public Slave slaveExample6() {
        Slave slave = new Slave();
        slave.setId(6);
        return slave;
    }
}

