/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class CursoredStreamTest
extends AutoVerifyTestCase {
    protected int size;
    protected Vector normalQueryObjects;
    protected Vector cursoredQueryObjects;
    protected Class referenceClass;
    protected Expression joinExpression;

    public CursoredStreamTest(Class referenceClass, Expression expression) {
        this.setReferenceClass(referenceClass);
        this.setName(this.getName() + "(" + referenceClass + ")");
        this.setDescription("This test verifies that the number of objects read in using a cursored stream matches the number of object read in using a normal query");
        this.joinExpression = expression;
    }

    public Vector getCursoredQueryObjects() {
        return this.cursoredQueryObjects;
    }

    public Vector getNormalQueryObjects() {
        return this.normalQueryObjects;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public int getSize() {
        return this.size;
    }

    public void setCursoredQueryObjects(Vector objects) {
        this.cursoredQueryObjects = objects;
    }

    public void setNormalQueryObjects(Vector objects) {
        this.normalQueryObjects = objects;
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
    }

    public void setSize(int aSize) {
        this.size = aSize;
    }

    protected void setup() {
        this.setNormalQueryObjects(this.getSession().readAllObjects(this.getReferenceClass(), this.joinExpression));
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        CursoredStream stream = null;
        try {
            this.cursoredQueryObjects = new Vector();
            query.setReferenceClass(this.getReferenceClass());
            query.setSelectionCriteria(this.joinExpression);
            query.useCursoredStream();
            stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
            CursoredStream stream2 = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
            try {
                stream2.read(5);
            }
            catch (QueryException ex) {
                // empty catch block
            }
            this.setSize(stream2.size());
            stream2.close();
            while (!stream.atEnd()) {
                Object databaseObject = stream.read();
                this.getCursoredQueryObjects().addElement(databaseObject);
                stream.releasePrevious();
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected void verify() {
        if (this.getNormalQueryObjects().size() != this.getCursoredQueryObjects().size()) {
            throw new TestErrorException("The number of streamed objects does not match the number of objects stored on the database.  Expected: " + this.getNormalQueryObjects().size() + ". Got: " + this.getCursoredQueryObjects().size());
        }
        if (this.getNormalQueryObjects().size() == 0) {
            throw new TestWarningException("no object with the specified selection criteria was found ");
        }
        if (this.getSize() != this.getNormalQueryObjects().size()) {
            throw new TestErrorException("The cursored stream size function is not working properly");
        }
        int first = 0;
        int last = this.getNormalQueryObjects().size() - 1;
        if (!((AbstractSession)this.getSession()).compareObjects(this.getCursoredQueryObjects().elementAt(first), this.getNormalQueryObjects().elementAt(first))) {
            throw new TestErrorException("The First Objects do not match");
        }
        if (!((AbstractSession)this.getSession()).compareObjects(this.getCursoredQueryObjects().elementAt(last), this.getNormalQueryObjects().elementAt(last))) {
            throw new TestErrorException("The Last Objects do not match");
        }
    }
}

