/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class CursoredStreamReleaseConnectionsTest
extends TestCase {
    protected int size;
    protected boolean useUOW;
    protected Server serverSession;
    protected ClientSession clientSession;

    public CursoredStreamReleaseConnectionsTest(boolean useUOW) {
        this.useUOW = useUOW;
        this.setDescription("This test verifies that the connections are released after executing a query using cursed stream");
        if (useUOW) {
            this.setName(this.getName() + " -UnitOfWork");
        } else {
            this.setName(this.getName() + " -ClientSession");
        }
    }

    public void setup() {
        EmployeeProject proj = new EmployeeProject();
        proj.setDatasourceLogin(this.getSession().getDatasourceLogin().clone());
        this.serverSession = proj.createServerSession();
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
    }

    public void reset() {
        if (this.clientSession != null) {
            this.clientSession.release();
        }
        this.serverSession.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        CursoredStream stream = null;
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            ReportQuery query = new ReportQuery(Employee.class, builder);
            query.addAttribute("lastName");
            query.useCursoredStream();
            query.retrievePrimaryKeys();
            this.clientSession = this.serverSession.acquireClientSession();
            if (this.useUOW) {
                UnitOfWorkImpl uow = this.clientSession.acquireUnitOfWork();
                stream = (CursoredStream)uow.executeQuery((DatabaseQuery)query);
            } else {
                stream = (CursoredStream)this.clientSession.executeQuery((DatabaseQuery)query);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public void verify() {
        int totalAvailable;
        int total = this.serverSession.getReadConnectionPool().getTotalNumberOfConnections();
        int totalUsedConnections = total - (totalAvailable = this.serverSession.getReadConnectionPool().getConnectionsAvailable().size());
        if (totalUsedConnections != 0) {
            throw new TestErrorException("Not all of the connections were released.");
        }
    }
}

