/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.inheritance.BudgettedProject;
import org.eclipse.persistence.testing.models.inheritance.ProjectWorker;

public class BindingWithShallowInsertTest
extends TestCase {
    protected boolean caughtException = false;
    protected boolean shouldBindParameters = false;
    protected ProjectWorker worker = null;

    public BindingWithShallowInsertTest() {
        this.setDescription("This test uses a set of mappings with a cycle to test shallow inserts.  It ensures that when a shallow insert occurs, null can properly be handled when binding parameters.");
    }

    public void setup() {
        this.caughtException = false;
        this.shouldBindParameters = this.getSession().getLogin().shouldBindAllParameters();
        this.getSession().getLogin().bindAllParameters();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        try {
            this.worker = new ProjectWorker();
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            ProjectWorker person = (ProjectWorker)uow.registerObject((Object)this.worker);
            person.setName("Gigere");
            BudgettedProject headProject = (BudgettedProject)uow.newInstance(BudgettedProject.class);
            headProject.setName("NA");
            headProject.setTitle("");
            headProject.setBudget(new Integer(-1));
            person.setHeadProject(headProject);
            person.addProject(headProject);
            uow.commit();
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            this.caughtException = true;
        }
    }

    public void verify() {
        if (this.caughtException) {
            throw new TestErrorException("An ArrayIndexOutOfBoundsException is throw when running a shallow  insert with a null parameter when using binding. This likely means that the parameter fields on  the SQLCall are not being properly maintained in the translate method.");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ProjectWorker resultWorker = (ProjectWorker)this.getSession().readObject((Object)this.worker);
        if (resultWorker == null || !resultWorker.getName().equals("Gigere") || resultWorker.getHeadProject() == null || resultWorker.getProjects().size() != 1) {
            throw new TestErrorException("The shallow insert of an object using binding with a null parameter was unsuccessful.");
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getSession().getLogin().setShouldBindAllParameters(this.shouldBindParameters);
    }
}

