/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cache;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ConcurrentAccessTest
extends AutoVerifyTestCase {
    CacheIdentityMap cache;

    public void test() {
        this.cache = new CacheIdentityMap(10, null, this.getAbstractSession(), false);
        Employee employee = new Employee();
        BigDecimal id = new BigDecimal(7777);
        Vector<BigDecimal> primaryKeys = new Vector<BigDecimal>();
        employee.setId(id);
        employee.setFirstName("Joe");
        employee.setLastName("Blow");
        primaryKeys.addElement(id);
        Updater updater1 = new Updater(employee, primaryKeys, this.cache);
        Thread thread1 = new Thread(updater1);
        employee = new Employee();
        id = new BigDecimal(6666);
        primaryKeys = new Vector();
        employee.setId(id);
        employee.setFirstName("Andy");
        employee.setLastName("Blow");
        primaryKeys.addElement(id);
        Updater updater2 = new Updater(employee, primaryKeys, this.cache);
        Thread thread2 = new Thread(updater2);
        employee = new Employee();
        id = new BigDecimal(5555);
        primaryKeys = new Vector();
        employee.setId(id);
        employee.setFirstName("Darlene");
        employee.setLastName("Blow");
        primaryKeys.addElement(id);
        Updater updater3 = new Updater(employee, primaryKeys, this.cache);
        Thread thread3 = new Thread(updater3);
        thread1.start();
        thread2.start();
        thread3.start();
        try {
            thread1.join();
            thread2.join();
            thread3.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (updater1.hadError() || updater2.hadError() || updater3.hadError()) {
            throw new TestErrorException("Null Pointer thrown within Cache Access");
        }
    }

    private class Updater
    implements Runnable {
        protected Object object;
        protected Vector primaryKeys;
        protected CacheIdentityMap cache;
        protected boolean experienceError = false;

        public Updater(Object object, Vector primaryKeys, CacheIdentityMap cache) {
            this.object = object;
            this.primaryKeys = primaryKeys;
            this.cache = cache;
        }

        @Override
        public void run() {
            try {
                for (int count = 0; count < 10000; ++count) {
                    this.cache.put((Object)this.primaryKeys, this.object, null, 0L);
                    this.cache.remove((Object)this.primaryKeys, null);
                }
            }
            catch (NullPointerException ex) {
                this.experienceError = true;
            }
        }

        public boolean hadError() {
            return this.experienceError;
        }
    }
}

