/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypes_AggregateObject {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class simpleTypeB = dcl.createDynamicClass("simple.mappings.SimpleB");
        DynamicTypeBuilder bTypeBuilder = new DynamicTypeBuilder(simpleTypeB, null, new String[0]);
        bTypeBuilder.addDirectMapping("value2", Boolean.TYPE, "VAL_2");
        bTypeBuilder.addDirectMapping("value3", String.class, "VAL_3");
        Class simpleTypeC = dcl.createDynamicClass("simple.mappings.SimpleC");
        DynamicTypeBuilder cTypeBuilder = new DynamicTypeBuilder(simpleTypeC, null, new String[0]);
        cTypeBuilder.addDirectMapping("value4", Double.TYPE, "VAL_4");
        cTypeBuilder.addDirectMapping("value5", String.class, "VAL_5");
        Class simpleTypeA = dcl.createDynamicClass("simple.mappings.SimpleA");
        DynamicTypeBuilder aTypeBuilder = new DynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A"});
        aTypeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        aTypeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        aTypeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        aTypeBuilder.addAggregateObjectMapping("b", bTypeBuilder.getType(), true);
        aTypeBuilder.addAggregateObjectMapping("c", cTypeBuilder.getType(), false);
        dynamicHelper.addTypes(true, true, new DynamicType[]{aTypeBuilder.getType(), bTypeBuilder.getType(), cTypeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_A");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearDynamicTables() {
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_A");
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        ClassDescriptor descriptorB = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleB");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((String)"'SimpleB' EntityType not found", (Object)simpleTypeB);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping b_value2 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value2");
        Assert.assertEquals(Boolean.TYPE, (Object)b_value2.getAttributeClassification());
        DirectToFieldMapping b_value3 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value3");
        Assert.assertEquals(String.class, (Object)b_value3.getAttributeClassification());
        Assert.assertTrue((boolean)descriptorB.isAggregateDescriptor());
        AggregateObjectMapping a_b = (AggregateObjectMapping)descriptorA.getMappingForAttributeName("b");
        Assert.assertSame((Object)descriptorB.getJavaClass(), (Object)a_b.getReferenceDescriptor().getJavaClass());
        Assert.assertTrue((boolean)a_b.isNullAllowed());
        ClassDescriptor descriptorC = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleC");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicType simpleTypeC = dynamicHelper.getType("SimpleC");
        Assert.assertNotNull((String)"'SimpleC' EntityType not found", (Object)simpleTypeC);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping c_value4 = (DirectToFieldMapping)descriptorC.getMappingForAttributeName("value4");
        Assert.assertEquals(Double.TYPE, (Object)c_value4.getAttributeClassification());
        DirectToFieldMapping c_value5 = (DirectToFieldMapping)descriptorC.getMappingForAttributeName("value5");
        Assert.assertEquals(String.class, (Object)c_value5.getAttributeClassification());
        Assert.assertTrue((boolean)descriptorB.isAggregateDescriptor());
        AggregateObjectMapping a_c = (AggregateObjectMapping)descriptorA.getMappingForAttributeName("c");
        Assert.assertSame((Object)descriptorC.getJavaClass(), (Object)a_c.getReferenceDescriptor().getJavaClass());
        Assert.assertFalse((boolean)a_c.isNullAllowed());
    }

    @Test
    public void verifyProperties() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        Assert.assertEquals((long)4L, (long)simpleTypeA.getNumberOfProperties());
        Assert.assertEquals((Object)"id", simpleTypeA.getPropertiesNames().get(0));
        Assert.assertEquals((Object)"value1", simpleTypeA.getPropertiesNames().get(1));
        Assert.assertEquals((Object)"b", simpleTypeA.getPropertiesNames().get(2));
        Assert.assertEquals((Object)"c", simpleTypeA.getPropertiesNames().get(3));
    }

    @Test
    public void createSimpleA() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity a = simpleTypeA.newDynamicEntity();
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)a.get("id"), (Object)0);
        Assert.assertFalse((boolean)a.isSet("id"));
        Assert.assertFalse((boolean)a.isSet("value1"));
        Assert.assertFalse((boolean)a.isSet("b"));
        DynamicType typeC = dynamicHelper.getType("SimpleC");
        Assert.assertEquals(a.get("c").getClass(), typeC.newDynamicEntity().getClass());
        DynamicEntity c = (DynamicEntity)a.get("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)c.get("value4"), (Object)0.0);
        Assert.assertFalse((boolean)c.isSet("value5"));
    }

    @Test
    public void persistSimpleA() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
    }

    @Test
    public void verifyChangTracking() {
        this.persistSimpleA();
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        UnitOfWork uow = session.acquireUnitOfWork();
        ReadObjectQuery roq = dynamicHelper.newReadObjectQuery("SimpleA");
        roq.setSelectionCriteria(roq.getExpressionBuilder().get("id").equal(1));
        DynamicEntityImpl sharedA = (DynamicEntityImpl)session.executeQuery((DatabaseQuery)roq);
        Assert.assertNotNull((Object)sharedA);
        Assert.assertNull((Object)sharedA._persistence_getPropertyChangeListener());
        DynamicEntityImpl a = (DynamicEntityImpl)uow.executeQuery((DatabaseQuery)roq);
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)a._persistence_getPropertyChangeListener());
        DynamicEntityImpl c = (DynamicEntityImpl)a.get("c");
        Assert.assertNotNull((Object)c);
        Assert.assertNotNull((Object)c._persistence_getPropertyChangeListener());
        Assert.assertTrue((boolean)(c._persistence_getPropertyChangeListener() instanceof AggregateAttributeChangeListener));
        uow.release();
    }

    @Test
    public void createSimpleAwithSimpleB() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        Assert.assertNotNull((Object)session.getDescriptorForAlias("SimpleB"));
        DynamicEntity simpleInstanceB = simpleTypeB.newDynamicEntity();
        simpleInstanceB.set("value2", (Object)true);
        simpleInstanceB.set("value3", (Object)"B2");
        DynamicEntity simpleInstanceA = simpleTypeA.newDynamicEntity();
        simpleInstanceA.set("id", (Object)2);
        simpleInstanceA.set("value1", (Object)"A2");
        simpleInstanceA.set("b", (Object)simpleInstanceB);
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstanceA);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCountA = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountA);
    }
}

