/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.collections;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.models.collections.Diner;
import org.eclipse.persistence.testing.models.collections.Location;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.Waiter;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Restaurant
implements ChangeTracker {
    private String name;
    private ValueHolderInterface menus;
    private Collection waiters;
    private BigDecimal id;
    private Collection locations = new ArrayList();
    private TreeSet locations2;
    private Map preferredCustomers;
    private ValueHolderInterface slogans;
    private ValueHolderInterface services;
    private Map licenses;
    public PropertyChangeListener listener;

    public Restaurant() {
        this.setLocations2(new TreeSet(Restaurant.getLocationComparator()));
        this.preferredCustomers = new Hashtable();
        this.menus = new ValueHolder(new Hashtable());
        this.slogans = new ValueHolder(new ArrayList());
        this.services = new ValueHolder(new ArrayList());
        this.licenses = new HashMap();
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listener != null && oldValue != newValue) {
            this.listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    public void collectionChange(String propertyName, Collection changedCollection, Object newObject, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new CollectionChangeEvent((Object)this, propertyName, (Object)changedCollection, newObject, changeType, isChangeApplied));
        }
    }

    public void mapChange(String propertyName, Map changedCollection, Object key, Object newObject, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new MapChangeEvent((Object)this, propertyName, (Object)changedCollection, key, newObject, changeType, isChangeApplied));
        }
    }

    public static Comparator getLocationComparator() {
        return new LocationComparator();
    }

    public void addDiner(Diner aDiner) {
        this.getDiners().put(aDiner.getLastName(), aDiner);
        aDiner.addFavouriteRestaurant(this);
        this.mapChange("preferredCustomers", this.getDiners(), aDiner.getLastName(), aDiner, MapChangeEvent.ADD, true);
    }

    public void addLocation(Location aLocation) {
        this.getLocations().add(aLocation);
        this.collectionChange("locations", this.getLocations(), aLocation, CollectionChangeEvent.ADD, true);
    }

    public void addMenu(Menu aMenu) {
        aMenu.setOwner(this);
        this.getMenus().put(aMenu.getKey(), aMenu);
        this.mapChange("menus", this.getDiners(), aMenu.getKey(), aMenu, MapChangeEvent.ADD, true);
    }

    public void removeMenu(Menu aMenu) {
        aMenu.setOwner((Restaurant)null);
        this.getMenus().remove(aMenu.getKey());
        this.mapChange("menus", this.getMenus(), aMenu.getKey(), aMenu, MapChangeEvent.REMOVE, true);
    }

    public String allToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Restaurant: " + this.getName());
        buf.append(Helper.cr());
        if (this.getMenus() != null) {
            buf.append("Menus: " + Helper.getShortClassName(this.getMenus().getClass()));
            buf.append(this.getMenus().toString());
            buf.append(Helper.cr());
        }
        if (this.getWaiters() != null) {
            buf.append("Waiters: " + Helper.getShortClassName(this.getWaiters().getClass()));
            buf.append(this.getWaiters().toString());
            buf.append(Helper.cr());
        }
        if (this.getPreferredCustomers() != null) {
            buf.append("PreferredCustomers: " + Helper.getShortClassName(this.getPreferredCustomers().getClass()));
            buf.append(this.getPreferredCustomers().toString());
            buf.append(Helper.cr());
        }
        if (this.getLocations() != null) {
            buf.append("Locations: " + Helper.getShortClassName(this.getLocations().getClass()));
            buf.append(this.getLocations().toString());
            buf.append(Helper.cr());
        }
        if (this.getSlogans() != null) {
            buf.append("Slogan: " + Helper.getShortClassName(this.getSlogans().getClass()));
            buf.append(this.getSlogans().toString());
            buf.append(Helper.cr());
        }
        return buf.toString();
    }

    public static Restaurant example1() {
        Restaurant rest = new Restaurant();
        rest.setName("Chez Abuse");
        ArrayList<Waiter> waiters = new ArrayList<Waiter>();
        waiters.add(Waiter.example1(rest));
        waiters.add(Waiter.example2(rest));
        waiters.add(Waiter.example3(rest));
        rest.setWaiters(waiters);
        Hashtable<String, Menu> menus = new Hashtable<String, Menu>();
        Menu menu = Menu.example1(rest);
        menus.put(menu.getType(), menu);
        menu = Menu.example2(rest);
        menus.put(menu.getType(), menu);
        menu = Menu.example3(rest);
        menus.put(menu.getType(), menu);
        rest.setMenus(menus);
        ArrayList<String> slogans = new ArrayList<String>();
        slogans.add("Fine food!");
        slogans.add("Even the escargots have attitude.");
        rest.setSlogans(slogans);
        rest.getServices().add("Reservations Required");
        rest.getServices().add("Formal Attire");
        rest.getLicenses().put("Alcohol License", Boolean.TRUE);
        rest.getLicenses().put("Smoking License", Boolean.TRUE);
        rest.getLicenses().put("Food License", Boolean.TRUE);
        return rest;
    }

    public static Restaurant example2() {
        Restaurant rest = new Restaurant();
        rest.setName("Pedro's");
        ArrayList<Waiter> waiters = new ArrayList<Waiter>();
        waiters.add(Waiter.example4(rest));
        waiters.add(Waiter.example5(rest));
        waiters.add(Waiter.example6(rest));
        rest.setWaiters(waiters);
        Hashtable<String, Menu> menus = new Hashtable<String, Menu>();
        Menu menu = Menu.example4(rest);
        menus.put(menu.getType(), menu);
        menu = Menu.example5(rest);
        menus.put(menu.getType(), menu);
        rest.setMenus(menus);
        ArrayList<String> slogans = new ArrayList<String>();
        slogans.add("Tacos are us.");
        slogans.add("Hot food!");
        rest.setSlogans(slogans);
        rest.getServices().add("Air Conditioning");
        rest.getLicenses().put("Alcohol License", Boolean.FALSE);
        rest.getLicenses().put("Smoking License", Boolean.FALSE);
        rest.getLicenses().put("Food License", Boolean.TRUE);
        return rest;
    }

    public static Restaurant example3() {
        Restaurant rest = new Restaurant();
        rest.setName("Yellow River");
        ArrayList<Waiter> waiters = new ArrayList<Waiter>();
        waiters.add(Waiter.example7(rest));
        rest.setWaiters(waiters);
        Hashtable<String, Menu> menus = new Hashtable<String, Menu>();
        Menu menu = Menu.example6(rest);
        menus.put(menu.getType(), menu);
        rest.setMenus(menus);
        ArrayList<String> slogans = new ArrayList<String>();
        slogans.add("Good food!");
        slogans.add("Yum, congee!.");
        rest.setSlogans(slogans);
        rest.getServices().add("Air Conditioning");
        rest.getServices().add("Reservations Required");
        rest.getLicenses().put("Alcohol License", Boolean.TRUE);
        rest.getLicenses().put("Smoking License", Boolean.FALSE);
        rest.getLicenses().put("Food License", Boolean.TRUE);
        return rest;
    }

    public Map getDiners() {
        return this.preferredCustomers;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public Collection getLocations() {
        return this.locations;
    }

    public Collection getServices() {
        return (Collection)this.services.getValue();
    }

    public Map getLicenses() {
        return this.licenses;
    }

    public TreeSet getLocations2() {
        return this.locations2;
    }

    public Map getMenus() {
        return (Map)this.getMenusHolder().getValue();
    }

    public ValueHolderInterface getMenusHolder() {
        return this.menus;
    }

    public String getName() {
        return this.name;
    }

    public Map getPreferredCustomers() {
        return this.preferredCustomers;
    }

    public Collection getSlogans() {
        return (Collection)this.getSlogansHolder().getValue();
    }

    public ValueHolderInterface getSlogansHolder() {
        return this.slogans;
    }

    public Collection getWaiters() {
        return this.waiters;
    }

    public void setId(BigDecimal newValue) {
        this.propertyChange("id", this.id, this.id);
        this.id = newValue;
    }

    public void setLocations(Collection newValue) {
        this.propertyChange("locations", this.locations, newValue);
        this.locations = newValue;
    }

    public void setLocations2(TreeSet newValue) {
        this.propertyChange("locations2", this.locations2, newValue);
        this.locations2 = newValue;
    }

    public void setMenus(Map newValue) {
        this.propertyChange("menus", this.getMenusHolder().getValue(), newValue);
        this.getMenusHolder().setValue((Object)newValue);
    }

    public void setMenusHolder(ValueHolderInterface aHolder) {
        this.menus = aHolder;
    }

    public void setName(String newValue) {
        this.propertyChange("name", this.name, newValue);
        this.name = newValue;
    }

    public void setPreferredCustomers(Map newValue) {
        this.propertyChange("preferredCustomers", this.preferredCustomers, newValue);
        this.preferredCustomers = newValue;
    }

    public void setSlogans(Collection aValue) {
        this.propertyChange("slogans", this.getSlogansHolder().getValue(), aValue);
        this.getSlogansHolder().setValue((Object)aValue);
    }

    public void setSlogansHolder(ValueHolderInterface newValue) {
        this.slogans = newValue;
    }

    public void setWaiters(Collection newValue) {
        this.propertyChange("waiters", this.waiters, newValue);
        this.waiters = newValue;
    }

    public static TableDefinition sloganTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_SLOG");
        definition.addField("REST_ID", BigDecimal.class, 15);
        definition.addField("SLOGAN", String.class, 200);
        return definition;
    }

    public static TableDefinition servicesTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_SERVICES");
        definition.addField("REST_ID", BigDecimal.class, 15);
        definition.addField("SERVICE", String.class, 5);
        return definition;
    }

    public static TableDefinition licensesTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_LICENSE");
        definition.addField("REST_ID", BigDecimal.class, 15);
        definition.addField("LICENSE", String.class, 2);
        definition.addField("STATUS", Integer.class);
        return definition;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_REST");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("NAME", String.class, 40);
        return definition;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Restaurant: " + this.getName());
        return buf.toString();
    }

    static class LocationComparator
    implements Comparator {
        LocationComparator() {
        }

        public int compare(Object object1, Object object2) {
            if (object1.getClass() != Location.class || object2.getClass() != Location.class) {
                throw new ClassCastException("Invalid comparison : " + object1 + ", " + object2);
            }
            Location loc1 = (Location)object1;
            Location loc2 = (Location)object2;
            return String.CASE_INSENSITIVE_ORDER.compare(loc1.getArea(), loc2.getArea());
        }
    }
}

