/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ReadObjectTest
extends AutoVerifyTestCase {
    protected ReadObjectQuery query;
    protected Object originalObject;
    protected Object objectFromDatabase;
    protected int logLevel;

    public ReadObjectTest() {
        this.setDescription("The test reads the intended object from the database and checks if it was read properly");
    }

    public ReadObjectTest(Object originalObject) {
        this.setOriginalObject(originalObject);
        if (originalObject == null) {
            this.setName("ReadObjectTest(null)");
        } else {
            this.setName("ReadObjectTest(" + originalObject.getClass() + ")");
        }
        this.setDescription("The test reads the intended object, '" + originalObject + "', from the database and checks if it was read properly");
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    public ReadObjectQuery getQuery() {
        return this.query;
    }

    public void setOriginalObject(Object originalObject) {
        this.originalObject = originalObject;
    }

    public void setQuery(ReadObjectQuery query) {
        this.query = query;
    }

    @Override
    protected void setup() {
        this.logLevel = this.getSession().getLogLevel();
        if (this.getName().indexOf("Joining") != -1) {
            this.getSession().setLogLevel(1);
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        if (this.getQuery() == null) {
            ReadObjectQuery query = new ReadObjectQuery();
            query.setSelectionObject(this.getOriginalObject());
            this.setQuery(query);
        }
    }

    @Override
    public void reset() throws Throwable {
        if (this.getName().indexOf("Joining") != -1) {
            this.getSession().setLogLevel(this.logLevel);
        }
    }

    @Override
    protected void test() {
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)this.getQuery());
    }

    @Override
    protected void verify() {
        if (this.getOriginalObject() == null && this.objectFromDatabase == null) {
            return;
        }
        if (!this.compareObjects(this.getOriginalObject(), this.objectFromDatabase)) {
            throw new TestErrorException("The object read from the database, '" + this.objectFromDatabase + "' does not match the originial, '" + this.getOriginalObject() + ".");
        }
    }
}

