/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.Collection;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;

public class JUnitDomainObjectComparer {
    AbstractSession theSession;

    public boolean compareObjects(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof Collection && !(obj2 instanceof Collection)) {
            return this.compareObjects(obj2, (Collection)obj1);
        }
        if (!(obj1 instanceof Collection) && obj2 instanceof Collection) {
            return this.compareObjects(obj1, (Collection)obj2);
        }
        if (obj1 instanceof Collection && obj2 instanceof Collection) {
            return this.compareObjects((Collection)obj1, (Collection)obj2);
        }
        return this.getSession().compareObjects(obj1, obj2);
    }

    public boolean compareObjects(Object domainObject1, Collection aCollection) {
        for (Object domainObject2 : aCollection) {
            if (!this.compareObjects(domainObject1, domainObject2)) continue;
            return true;
        }
        return false;
    }

    public boolean compareObjects(Collection objects1, Collection objects2) {
        boolean allMatched = true;
        if (objects1.size() != objects2.size()) {
            allMatched = false;
        }
        for (Object obj1 : objects1) {
            Project proj2;
            Project proj1;
            if (obj1 == null) {
                allMatched &= objects2.contains(null);
                continue;
            }
            if (obj1.getClass().equals(Employee.class)) {
                Employee emp1 = (Employee)obj1;
                Employee emp2 = this.findEmployeeByIdIn(emp1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)emp1, emp2);
            }
            if (obj1.getClass().equals(Project.class)) {
                proj1 = (Project)obj1;
                proj2 = this.findProjectByIdIn(proj1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)proj1, proj2);
            }
            if (obj1.getClass().equals(LargeProject.class)) {
                proj1 = (Project)obj1;
                proj2 = this.findProjectByIdIn(proj1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)proj1, proj2);
            }
            if (obj1.getClass().equals(PhoneNumber.class)) {
                PhoneNumber phone1 = (PhoneNumber)obj1;
                PhoneNumber phone2 = this.findPhoneNumberIn(phone1, objects2);
                boolean bl = allMatched = allMatched && this.compareObjects((Object)phone1, phone2);
            }
            if (!obj1.getClass().equals(String.class)) continue;
            allMatched = allMatched && objects2.contains(obj1);
        }
        return allMatched;
    }

    public PhoneNumber findPhoneNumberIn(PhoneNumber phone1, Collection phones) {
        for (PhoneNumber pTemp : phones) {
            if (pTemp == null || !pTemp.getNumber().equals(phone1.getNumber()) || !pTemp.getAreaCode().equals(phone1.getAreaCode()) || !pTemp.getOwner().getId().equals(phone1.getOwner().getId())) continue;
            return pTemp;
        }
        return null;
    }

    public Project findProjectByIdIn(Project project, Collection projects) {
        for (Project pTemp : projects) {
            if (pTemp == null || !pTemp.getId().equals(project.getId())) continue;
            return pTemp;
        }
        return null;
    }

    public Employee findEmployeeByIdIn(Employee emp, Collection employees) {
        for (Employee eTemp : employees) {
            if (eTemp == null || !eTemp.getId().equals(emp.getId())) continue;
            return eTemp;
        }
        return null;
    }

    public Address findAddressByIdIn(Address addr, Collection addresses) {
        for (Address aTemp : addresses) {
            if (aTemp == null || aTemp.getID() != addr.getID()) continue;
            return aTemp;
        }
        return null;
    }

    public AbstractSession getSession() {
        return this.theSession;
    }

    public void setSession(AbstractSession theSession) {
        this.theSession = theSession;
    }
}

