/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;

public class OptimisticLockForceIncrementTestSuite
extends JUnitTestCase {
    public OptimisticLockForceIncrementTestSuite() {
    }

    public OptimisticLockForceIncrementTestSuite(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite("OptimisticLockForceIncrementTestSuite");
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testSetup"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementCommitNoChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementFlushCommitNoChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementNoChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPostFlushChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPreAndPostFlushChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPreCommitChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPreFlushChanges"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testVersionIncrementNoChanges() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        List addresses = em.createQuery("select a from Address a").getResultList();
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
        OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
        Address entity = (Address)addresses.get(0);
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
        int startVersion = entity.getVersion();
        em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        em.flush();
        em.getTransaction().commit();
        int expectedVersion = startVersion + 1;
        int actualVersion = entity.getVersion();
        em.close();
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
    }

    public void testVersionIncrementPreFlushChanges() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        List addresses = em.createQuery("select a from Address a").getResultList();
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
        OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
        Address entity = (Address)addresses.get(0);
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
        int startVersion = entity.getVersion();
        em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        entity.setCity("Vancouver");
        entity.setProvince("BC");
        entity.setCountry("Canada");
        em.flush();
        em.getTransaction().commit();
        int expectedVersion = startVersion + 1;
        int actualVersion = entity.getVersion();
        em.close();
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Vancouver", (String)entity.getCity());
    }

    public void testVersionIncrementPostFlushChanges() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        List addresses = em.createQuery("select a from Address a").getResultList();
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
        OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
        Address entity = (Address)addresses.get(0);
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
        int startVersion = entity.getVersion();
        em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        em.flush();
        entity.setCity("Toronto");
        entity.setProvince("ON");
        entity.setCountry("Canada");
        em.getTransaction().commit();
        int expectedVersion = startVersion + 1;
        int actualVersion = entity.getVersion();
        em.close();
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Toronto", (String)entity.getCity());
    }

    public void testVersionIncrementPreAndPostFlushChanges() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        List addresses = em.createQuery("select a from Address a").getResultList();
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
        OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
        Address entity = (Address)addresses.get(0);
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
        int startVersion = entity.getVersion();
        em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        entity.setCity("Moncton");
        entity.setProvince("NB");
        entity.setCountry("Canada");
        em.flush();
        entity.setCity("Halifax");
        entity.setProvince("NS");
        entity.setCountry("Canada");
        em.getTransaction().commit();
        int expectedVersion = startVersion + 1;
        int actualVersion = entity.getVersion();
        em.close();
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Halifax", (String)entity.getCity());
    }

    public void testVersionIncrementCommitNoChanges() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        List addresses = em.createQuery("select a from Address a").getResultList();
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
        OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
        Address entity = (Address)addresses.get(0);
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
        int startVersion = entity.getVersion();
        em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        em.getTransaction().commit();
        int expectedVersion = startVersion + 1;
        int actualVersion = entity.getVersion();
        em.close();
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
    }

    public void testVersionIncrementPreCommitChanges() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        List addresses = em.createQuery("select a from Address a").getResultList();
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
        OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
        Address entity = (Address)addresses.get(0);
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
        int startVersion = entity.getVersion();
        em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        entity.setCity("Calgary");
        entity.setProvince("AB");
        entity.setCountry("Canada");
        em.getTransaction().commit();
        int expectedVersion = startVersion + 1;
        int actualVersion = entity.getVersion();
        em.close();
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Calgary", (String)entity.getCity());
    }

    public void testVersionIncrementFlushCommitNoChanges() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        List addresses = em.createQuery("select a from Address a").getResultList();
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
        OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
        Address entity = (Address)addresses.get(0);
        OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
        int startVersion = entity.getVersion();
        em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
        em.flush();
        em.getTransaction().commit();
        int expectedVersion = startVersion + 1;
        int actualVersion = entity.getVersion();
        em.close();
        OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
    }
}

