/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.node;

import org.eclipse.persistence.tools.workbench.utility.SynchronizedBoolean;
import org.eclipse.persistence.tools.workbench.utility.node.AsynchronousValidator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.SynchronousValidator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class PluggableValidator
implements Node.Validator {
    private boolean pause = false;
    private Delegate delegate;

    public static Node.Validator buildAsynchronousValidator(SynchronizedBoolean validateFlag) {
        return new PluggableValidator(new AsynchronousValidator(validateFlag));
    }

    public static Node.Validator buildSynchronousValidator(Node node) {
        return new PluggableValidator(new SynchronousValidator(node));
    }

    public PluggableValidator(Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public void validate() {
        if (!this.pause) {
            this.delegate.validate();
        }
    }

    @Override
    public void pause() {
        if (this.pause) {
            throw new IllegalStateException("already paused");
        }
        this.pause = true;
    }

    @Override
    public void resume() {
        if (!this.pause) {
            throw new IllegalStateException("not paused");
        }
        this.pause = false;
        this.delegate.validate();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.delegate);
    }

    public static interface Delegate {
        public static final Delegate NULL_DELEGATE = new Delegate(){

            @Override
            public void validate() {
            }

            public String toString() {
                return "NULL_DELEGATE";
            }
        };

        public void validate();
    }
}

