/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassDeclaration;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.FieldPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.VisitorAdapter;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.ObjectType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ClassFile {
    private Header header;
    private ConstantPool constantPool;
    private ClassDeclaration declaration;
    private FieldPool fieldPool;
    private MethodPool methodPool;
    private AttributePool attributePool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile fromInputStream(InputStream stream) throws IOException {
        ClassFile classFile = null;
        try {
            stream = new BufferedInputStream(stream);
            classFile = new ClassFile(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return classFile;
    }

    public static ClassFile fromArchiveEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        return ClassFile.fromInputStream(jarFile.getInputStream(jarEntry));
    }

    public static ClassFile fromArchiveEntry(JarFile jarFile, String className) throws IOException {
        String entryName = Classpath.convertToArchiveClassFileEntryName(className);
        return ClassFile.fromInputStream(jarFile.getInputStream(jarFile.getJarEntry(entryName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile fromArchiveEntry(File file, String className) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            ClassFile classFile = ClassFile.fromArchiveEntry(jarFile, className);
            return classFile;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    public static ClassFile fromFile(File file) throws IOException {
        return ClassFile.fromInputStream(new FileInputStream(file));
    }

    public static ClassFile fromClassFile(File classpathEntryDirectory, String className) throws IOException {
        return ClassFile.fromFile(new File(classpathEntryDirectory, Classpath.convertToClassFileName(className)));
    }

    public static ClassFile forClass(File classPathEntry, String className) throws IOException {
        if (Classpath.fileNameIsArchive(classPathEntry.getPath())) {
            return ClassFile.fromArchiveEntry(classPathEntry, className);
        }
        return ClassFile.fromClassFile(classPathEntry, className);
    }

    public static ClassFile forClass(Class javaClass) throws IOException {
        return ClassFile.forClass(new File(Classpath.locationFor(javaClass)), javaClass.getName());
    }

    public ClassFile(InputStream stream) throws IOException {
        this.initialize(new ClassFileDataInputStream(stream));
    }

    private void initialize(ClassFileDataInputStream stream) throws IOException {
        this.header = new Header(stream);
        this.constantPool = new ConstantPool(stream);
        this.declaration = new ClassDeclaration(stream, this.constantPool);
        this.fieldPool = new FieldPool(stream, this);
        this.methodPool = new MethodPool(stream, this);
        this.attributePool = new AttributePool(stream, this);
        if (this.isNestedClass()) {
            this.declaration.setStandardAccessFlagsForNestedClass(this.nestedClassAccessFlags());
        }
    }

    public String className() {
        return this.declaration.thisClassName();
    }

    public String displayString() {
        StringWriter sw = new StringWriter(2000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        writer.print("ClassFile: ");
        writer.println(this.className());
        writer.indent();
        this.header.displayStringOn(writer);
        this.constantPool.displayStringOn(writer);
        this.declaration.displayStringOn(writer);
        this.fieldPool.displayStringOn(writer);
        this.methodPool.displayStringOn(writer);
        this.attributePool.displayStringOn(writer);
        writer.undent();
    }

    public short standardAccessFlags() {
        return this.declaration.standardAccessFlags();
    }

    public boolean isInterface() {
        return this.declaration.isInterface();
    }

    public boolean isClass() {
        return this.declaration.isClass();
    }

    public String superClassName() {
        return this.declaration.superClassName();
    }

    public String[] interfaceNames() {
        return this.declaration.interfaceNames();
    }

    public boolean isDeprecated() {
        return this.attributePool.isDeprecated();
    }

    public boolean isSynthetic() {
        return this.declaration.isSynthetic() || this.attributePool.isSynthetic();
    }

    public boolean isTopLevelClass() {
        return !this.isNestedClass();
    }

    public boolean isNestedClass() {
        return this.attributePool.isNestedClass();
    }

    public boolean isMemberClass() {
        return this.attributePool.isMemberClass();
    }

    public boolean isLocalClass() {
        return this.attributePool.isLocalClass();
    }

    public boolean isAnonymousClass() {
        return this.attributePool.isAnonymousClass();
    }

    public String sourceFileName() {
        return this.attributePool.sourceFileName();
    }

    public String declaringClassName() {
        return this.attributePool.declaringClassName();
    }

    public String nestedClassName() {
        return this.attributePool.nestedClassName();
    }

    public short nestedClassAccessFlags() {
        return this.attributePool.nestedClassAccessFlags();
    }

    public String[] nestedClassNames() {
        return this.attributePool.nestedClassNames();
    }

    public String[] declaredMemberClassNames() {
        return this.attributePool.declaredMemberClassNames();
    }

    public String[] referencedClassNames() {
        return new ReferencedClassNamesVisitor(this).referencedClassNames();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.header.accept(visitor);
        this.constantPool.accept(visitor);
        this.declaration.accept(visitor);
        this.fieldPool.accept(visitor);
        this.methodPool.accept(visitor);
        this.attributePool.accept(visitor);
    }

    public Header getHeader() {
        return this.header;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public ClassDeclaration getDeclaration() {
        return this.declaration;
    }

    public FieldPool getFieldPool() {
        return this.fieldPool;
    }

    public MethodPool getMethodPool() {
        return this.methodPool;
    }

    public AttributePool getAttributePool() {
        return this.attributePool;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.className() + ')';
    }

    private static class ReferencedClassNamesVisitor
    extends VisitorAdapter {
        private final Collection referencedClassNames = new HashSet(200);

        ReferencedClassNamesVisitor(ClassFile classFile) {
            classFile.accept(this);
        }

        @Override
        public void visit(ObjectType objectType) {
            this.addReferencedClassName(objectType.elementTypeName());
        }

        private void addReferencedClassName(String className) {
            if (ClassTools.classNamedIsReference(className)) {
                this.referencedClassNames.add(className);
            }
        }

        String[] referencedClassNames() {
            return this.referencedClassNames.toArray(new String[this.referencedClassNames.size()]);
        }
    }

    public static class Header {
        private int magic;
        private short minorVersion;
        private short majorVersion;

        Header(ClassFileDataInputStream stream) throws IOException {
            this.initialize(stream);
        }

        private void initialize(ClassFileDataInputStream stream) throws IOException {
            this.magic = stream.readU4();
            if (this.magic != -889275714) {
                throw new IOException("bad magic");
            }
            this.minorVersion = stream.readU2();
            this.majorVersion = stream.readU2();
        }

        public String displayString() {
            StringWriter sw = new StringWriter();
            IndentingPrintWriter writer = new IndentingPrintWriter(sw);
            this.displayStringOn(writer);
            return sw.toString();
        }

        public void displayStringOn(IndentingPrintWriter writer) {
            writer.println("Header");
            writer.indent();
            writer.print("magic: 0x");
            writer.println(this.magicString());
            writer.print("class file format version: ");
            writer.println(this.version());
            writer.undent();
        }

        public String magicString() {
            return Integer.toHexString(this.magic).toUpperCase();
        }

        public float version() {
            float temp;
            for (temp = (float)this.minorVersion; temp > 1.0f; temp /= 10.0f) {
            }
            return (float)this.majorVersion + temp;
        }

        public String versionString() {
            return String.valueOf(this.version());
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public int getMagic() {
            return this.magic;
        }

        public short getMinorVersion() {
            return this.minorVersion;
        }

        public short getMajorVersion() {
            return this.majorVersion;
        }

        public String toString() {
            return ClassTools.shortClassNameForObject(this) + "(class file version: " + this.version() + ')';
        }
    }
}

