/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeToJavaTypeDeclarationMapping;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclarationToJDBCTypeMapping;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JDBCTypeRepository
extends AbstractNodeModel {
    private Collection jdbcTypes;
    public static final String JDBC_TYPES_COLLECTION = "jdbcTypes";
    private static final int[] DEFAULT_UNUSED_JDBC_TYPE_CODES = new int[]{0};
    private JDBCType defaultJDBCType;
    public static final String DEFAULT_JDBC_TYPE_PROPERTY = "defaultJDBCType";
    private static final int DEFAULT_DEFAULT_JDBC_TYPE_CODE = 12;
    private Collection jdbcTypeToJavaTypeDeclarationMappings;
    public static final String JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION = "jdbcTypeToJavaTypeDeclarationMappings";
    private Collection javaTypeDeclarationToJDBCTypeMappings;
    public static final String JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION = "javaTypeDeclarationToJDBCTypeMappings";
    private static final boolean JDK16 = JDBCTypeRepository.jdkIsVersion("1.6");

    private static boolean jdkIsVersion(String version) {
        return System.getProperty("java.version").indexOf(version) != -1;
    }

    JDBCTypeRepository(DatabasePlatformRepository platformRepository, Node node) throws CorruptXMLException {
        super(platformRepository);
        this.read(node);
    }

    JDBCTypeRepository(DatabasePlatformRepository platformRepository) {
        super(platformRepository);
        this.initializeDefaults();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.jdbcTypes = new Vector();
        this.jdbcTypeToJavaTypeDeclarationMappings = new Vector();
        this.javaTypeDeclarationToJDBCTypeMappings = new Vector();
    }

    private void initializeDefaults() {
        this.initializeDefaultJDBCTypes();
        this.defaultJDBCType = this.jdbcTypeForCode(12);
        this.initializeDefaultJDBCToJavaMappings();
        if (!JDK16) {
            this.checkJDBCTypeToJavaTypeDeclarationMappings();
        }
        this.initializeDefaultJavaToJDBCMappings();
    }

    private void checkJDBCTypeToJavaTypeDeclarationMappings() {
        if (this.jdbcTypeToJavaTypeDeclarationMappings.size() != this.jdbcTypes.size()) {
            throw new IllegalStateException("the JDBC type mappings were not initialized properly");
        }
    }

    private void initializeDefaultJDBCTypes() {
        Field[] fields = Types.class.getDeclaredFields();
        int i = fields.length;
        while (i-- > 0) {
            int code;
            String name = fields[i].getName();
            try {
                code = (Integer)fields[i].get(null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            if (CollectionTools.contains(DEFAULT_UNUSED_JDBC_TYPE_CODES, code)) continue;
            this.checkJDBCType(name, code);
            this.jdbcTypes.add(new JDBCType(this, name, code));
        }
    }

    private void initializeDefaultJDBCToJavaMappings() {
        this.addJDBCToJavaMapping(2003, Array.class);
        this.addJDBCToJavaMapping(-5, Long.TYPE);
        this.addJDBCToJavaMapping(-2, Byte.TYPE, 1);
        this.addJDBCToJavaMapping(-7, Boolean.TYPE);
        this.addJDBCToJavaMapping(2004, Blob.class);
        this.addJDBCToJavaMapping(16, Boolean.TYPE);
        this.addJDBCToJavaMapping(1, String.class);
        this.addJDBCToJavaMapping(2005, Clob.class);
        this.addJDBCToJavaMapping(70, URL.class);
        this.addJDBCToJavaMapping(91, Date.class);
        this.addJDBCToJavaMapping(3, BigDecimal.class);
        this.addJDBCToJavaMapping(2001, Object.class);
        this.addJDBCToJavaMapping(8, Double.TYPE);
        this.addJDBCToJavaMapping(6, Double.TYPE);
        this.addJDBCToJavaMapping(4, Integer.TYPE);
        this.addJDBCToJavaMapping(2000, Object.class);
        this.addJDBCToJavaMapping(-4, Byte.TYPE, 1);
        this.addJDBCToJavaMapping(-1, String.class);
        this.addJDBCToJavaMapping(2, BigDecimal.class);
        this.addJDBCToJavaMapping(1111, Object.class);
        this.addJDBCToJavaMapping(7, Float.TYPE);
        this.addJDBCToJavaMapping(2006, Ref.class);
        this.addJDBCToJavaMapping(5, Short.TYPE);
        this.addJDBCToJavaMapping(2002, Struct.class);
        this.addJDBCToJavaMapping(92, Time.class);
        this.addJDBCToJavaMapping(93, Timestamp.class);
        this.addJDBCToJavaMapping(-6, Byte.TYPE);
        this.addJDBCToJavaMapping(-3, Byte.TYPE, 1);
        this.addJDBCToJavaMapping(12, String.class);
    }

    private void addJDBCToJavaMapping(int jdbcTypeCode, Class javaClass) {
        this.addJDBCToJavaMapping(jdbcTypeCode, javaClass, 0);
    }

    private void addJDBCToJavaMapping(int jdbcTypeCode, Class javaClass, int arrayDepth) {
        JDBCType jdbcType = this.jdbcTypeForCode(jdbcTypeCode);
        this.checkJDBCToJavaMapping(jdbcType);
        this.jdbcTypeToJavaTypeDeclarationMappings.add(new JDBCTypeToJavaTypeDeclarationMapping(this, jdbcType, javaClass.getName(), arrayDepth));
    }

    private void initializeDefaultJavaToJDBCMappings() {
        this.addJavaToJDBCMapping(String.class, 12);
        this.addJavaToJDBCMapping(Boolean.TYPE, 16);
        this.addJavaToJDBCMapping(Boolean.class, 16);
        this.addJavaToJDBCMapping(Character.TYPE, 1);
        this.addJavaToJDBCMapping(Character.class, 1);
        this.addJavaToJDBCMapping(Byte.TYPE, -6);
        this.addJavaToJDBCMapping(Byte.class, -6);
        this.addJavaToJDBCMapping(Short.TYPE, 5);
        this.addJavaToJDBCMapping(Short.class, 5);
        this.addJavaToJDBCMapping(Integer.TYPE, 4);
        this.addJavaToJDBCMapping(Integer.class, 4);
        this.addJavaToJDBCMapping(Long.TYPE, -5);
        this.addJavaToJDBCMapping(Long.class, -5);
        this.addJavaToJDBCMapping(Float.TYPE, 7);
        this.addJavaToJDBCMapping(Float.class, 7);
        this.addJavaToJDBCMapping(Double.TYPE, 8);
        this.addJavaToJDBCMapping(Double.class, 8);
        this.addJavaToJDBCMapping(Number.class, 2);
        this.addJavaToJDBCMapping(BigDecimal.class, 2);
        this.addJavaToJDBCMapping(BigInteger.class, 2);
        this.addJavaToJDBCMapping(java.util.Date.class, 91);
        this.addJavaToJDBCMapping(Date.class, 91);
        this.addJavaToJDBCMapping(Time.class, 92);
        this.addJavaToJDBCMapping(Timestamp.class, 93);
        this.addJavaToJDBCMapping(Calendar.class, 93);
        this.addJavaToJDBCMapping(Blob.class, 2004);
        this.addJavaToJDBCMapping(Clob.class, 2005);
        this.addJavaToJDBCMapping(Array.class, 2003);
        this.addJavaToJDBCMapping(Struct.class, 2002);
        this.addJavaToJDBCMapping(Ref.class, 2006);
        this.addJavaToJDBCMapping(URL.class, 70);
        this.addJavaToJDBCMapping(Byte.TYPE, 1, -3);
        this.addJavaToJDBCMapping(Character.TYPE, 1, 12);
        this.addJavaToJDBCMapping(Class.class, 12);
    }

    private void addJavaToJDBCMapping(Class javaClass, int jdbcTypeCode) {
        this.addJavaToJDBCMapping(javaClass, 0, jdbcTypeCode);
    }

    private void addJavaToJDBCMapping(Class javaClass, int arrayDepth, int jdbcTypeCode) {
        String javaClassName = javaClass.getName();
        this.checkJavaToJDBCMapping(javaClassName, arrayDepth);
        this.javaTypeDeclarationToJDBCTypeMappings.add(new JavaTypeDeclarationToJDBCTypeMapping(this, javaClassName, arrayDepth, this.jdbcTypeForCode(jdbcTypeCode)));
    }

    private DatabasePlatformRepository getPlatformRepository() {
        return (DatabasePlatformRepository)this.getParent();
    }

    public Iterator jdbcTypes() {
        return new CloneIterator(this.jdbcTypes){

            @Override
            protected void remove(Object current) {
                JDBCTypeRepository.this.removeJDBCType((JDBCType)current);
            }
        };
    }

    public int jdbcTypesSize() {
        return this.jdbcTypes.size();
    }

    public JDBCType addJDBCType(String name, int code) {
        this.checkJDBCType(name, code);
        return this.addJDBCType(new JDBCType(this, name, code));
    }

    private JDBCType addJDBCType(JDBCType jdbcType) {
        this.addItemToCollection(jdbcType, this.jdbcTypes, JDBC_TYPES_COLLECTION);
        this.jdbcTypeAdded(jdbcType);
        return jdbcType;
    }

    private void jdbcTypeAdded(JDBCType addedJDBCType) {
        this.addJDBCTypeToJavaTypeDeclarationMapping(addedJDBCType, Object.class.getName(), 0);
        this.getPlatformRepository().jdbcTypeAdded(addedJDBCType);
    }

    public void removeJDBCType(JDBCType jdbcType) {
        if (jdbcType == this.defaultJDBCType) {
            throw new IllegalArgumentException("the default JDBC type may not be removed: " + jdbcType);
        }
        this.removeItemFromCollection(jdbcType, this.jdbcTypes, JDBC_TYPES_COLLECTION);
        this.jdbcTypeRemoved(jdbcType);
    }

    private void jdbcTypeRemoved(JDBCType removedJDBCType) {
        Iterator stream = this.jdbcTypeToJavaTypeDeclarationMappings();
        while (stream.hasNext()) {
            if (((JDBCTypeToJavaTypeDeclarationMapping)stream.next()).getJDBCType() != removedJDBCType) continue;
            stream.remove();
            break;
        }
        stream = this.javaTypeDeclarationToJDBCTypeMappings();
        while (stream.hasNext()) {
            JavaTypeDeclarationToJDBCTypeMapping mapping = (JavaTypeDeclarationToJDBCTypeMapping)stream.next();
            if (mapping.getJDBCType() != removedJDBCType) continue;
            mapping.setJDBCType(this.defaultJDBCType);
        }
        this.getPlatformRepository().nodeRemoved(removedJDBCType);
    }

    public void removeJDBCTypes(Collection types) {
        if (types.contains(this.defaultJDBCType)) {
            throw new IllegalArgumentException("the default JDBC type may not be removed: " + this.defaultJDBCType);
        }
        this.removeItemsFromCollection(types, this.jdbcTypes, JDBC_TYPES_COLLECTION);
        this.jdbcTypesRemoved(types);
    }

    private void jdbcTypesRemoved(Collection removedJDBCTypes) {
        Iterator stream = removedJDBCTypes.iterator();
        while (stream.hasNext()) {
            this.jdbcTypeRemoved((JDBCType)stream.next());
        }
    }

    public void removeJDBCTypes(Iterator types) {
        this.removeJDBCTypes(CollectionTools.collection(types));
    }

    public JDBCType getDefaultJDBCType() {
        return this.defaultJDBCType;
    }

    public void setDefaultJDBCType(JDBCType defaultJDBCType) {
        if (defaultJDBCType == null) {
            throw new NullPointerException();
        }
        JDBCType old = this.defaultJDBCType;
        this.defaultJDBCType = defaultJDBCType;
        this.firePropertyChanged(DEFAULT_JDBC_TYPE_PROPERTY, old, defaultJDBCType);
    }

    public Iterator jdbcTypeToJavaTypeDeclarationMappings() {
        return new CloneIterator(this.jdbcTypeToJavaTypeDeclarationMappings){

            @Override
            protected void remove(Object current) {
                JDBCTypeRepository.this.removeJDBCTypeToJavaTypeDeclarationMapping((JDBCTypeToJavaTypeDeclarationMapping)current);
            }
        };
    }

    public int jdbcTypeToJavaTypeDeclarationMappingsSize() {
        return this.jdbcTypeToJavaTypeDeclarationMappings.size();
    }

    public JDBCTypeToJavaTypeDeclarationMapping addJDBCTypeToJavaTypeDeclarationMapping(JDBCType jdbcType, String javaClassName, int arrayDepth) {
        this.checkJDBCToJavaMapping(jdbcType);
        return this.addJDBCTypeToJavaTypeDeclarationMapping(new JDBCTypeToJavaTypeDeclarationMapping(this, jdbcType, javaClassName, arrayDepth));
    }

    private JDBCTypeToJavaTypeDeclarationMapping addJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeToJavaTypeDeclarationMapping mapping) {
        this.addItemToCollection(mapping, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
        return mapping;
    }

    public void removeJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeToJavaTypeDeclarationMapping mapping) {
        this.removeItemFromCollection(mapping, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
    }

    public void removeJDBCTypeToJavaTypeDeclarationMappings(Collection mappings) {
        this.removeItemsFromCollection(mappings, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
    }

    public void removeJDBCTypeToJavaTypeDeclarationMappings(Iterator mappings) {
        this.removeItemsFromCollection(mappings, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
    }

    public Iterator javaTypeDeclarationToJDBCTypeMappings() {
        return new CloneIterator(this.javaTypeDeclarationToJDBCTypeMappings){

            @Override
            protected void remove(Object current) {
                JDBCTypeRepository.this.removeJavaTypeDeclarationToJDBCTypeMapping((JavaTypeDeclarationToJDBCTypeMapping)current);
            }
        };
    }

    public int javaTypeDeclarationToJDBCTypeMappingsSize() {
        return this.javaTypeDeclarationToJDBCTypeMappings.size();
    }

    public JavaTypeDeclarationToJDBCTypeMapping addJavaTypeDeclarationToJDBCTypeMapping(String javaClassName, int arrayDepth, JDBCType jdbcType) {
        this.checkJavaToJDBCMapping(javaClassName, arrayDepth);
        return this.addJavaTypeDeclarationToJDBCTypeMapping(new JavaTypeDeclarationToJDBCTypeMapping(this, javaClassName, arrayDepth, jdbcType));
    }

    private JavaTypeDeclarationToJDBCTypeMapping addJavaTypeDeclarationToJDBCTypeMapping(JavaTypeDeclarationToJDBCTypeMapping mapping) {
        this.addItemToCollection(mapping, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
        return mapping;
    }

    public void removeJavaTypeDeclarationToJDBCTypeMapping(JavaTypeDeclarationToJDBCTypeMapping mapping) {
        this.removeItemFromCollection(mapping, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
    }

    public void removeJavaTypeDeclarationToJDBCTypeMappings(Collection mappings) {
        this.removeItemsFromCollection(mappings, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
    }

    public void removeJavaTypeDeclarationToJDBCTypeMappings(Iterator mappings) {
        this.removeItemsFromCollection(mappings, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
    }

    public JDBCType jdbcTypeForCode(int jdbcTypeCode) {
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            for (JDBCType jdbcType : this.jdbcTypes) {
                if (jdbcType.getCode() != jdbcTypeCode) continue;
                return jdbcType;
            }
            throw new IllegalArgumentException("missing JDBC type for code: " + jdbcTypeCode);
        }
    }

    JDBCType jdbcTypeNamed(String jdbcTypeName) {
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            for (JDBCType jdbcType : this.jdbcTypes) {
                if (!jdbcType.getName().equals(jdbcTypeName)) continue;
                return jdbcType;
            }
            throw new IllegalArgumentException("missing JDBC type named: " + jdbcTypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jdbcTypeCanBeMappedToJavaTypeDeclaration(JDBCType jdbcType) {
        Collection collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            Iterator stream = this.jdbcTypeToJavaTypeDeclarationMappings.iterator();
            while (stream.hasNext()) {
                if (!((JDBCTypeToJavaTypeDeclarationMapping)stream.next()).maps(jdbcType)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean javaTypeDeclarationCanBeMappedToJDBCType(String javaClassName, int arrayDepth) {
        Collection collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            Iterator stream = this.javaTypeDeclarationToJDBCTypeMappings.iterator();
            while (stream.hasNext()) {
                if (!((JavaTypeDeclarationToJDBCTypeMapping)stream.next()).maps(javaClassName, arrayDepth)) continue;
                return true;
            }
            return false;
        }
    }

    JDBCType jdbcTypeForJavaTypeDeclaration(String javaClassName, int arrayDepth) {
        Collection collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            for (JavaTypeDeclarationToJDBCTypeMapping mapping : this.javaTypeDeclarationToJDBCTypeMappings) {
                if (!mapping.maps(javaClassName, arrayDepth)) continue;
                return mapping.getJDBCType();
            }
            throw new IllegalArgumentException("missing JDBC type mapping for Java type declaration: " + javaClassName + this.brackets(arrayDepth));
        }
    }

    JavaTypeDeclaration javaTypeDeclarationFor(JDBCType jdbcType) {
        Collection collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            for (JDBCTypeToJavaTypeDeclarationMapping mapping : this.jdbcTypeToJavaTypeDeclarationMappings) {
                if (!mapping.maps(jdbcType)) continue;
                return mapping.getJavaTypeDeclaration();
            }
            throw new IllegalArgumentException("missing Java type declaration mapping for JDBC type: " + jdbcType);
        }
    }

    JavaTypeDeclaration javaTypeDeclarationForJDBCTypeCode(int jdbcTypeCode) {
        return this.javaTypeDeclarationFor(this.jdbcTypeForCode(jdbcTypeCode));
    }

    private Iterator jdbcTypeNames() {
        return new TransformationIterator(this.jdbcTypes()){

            @Override
            protected Object transform(Object next) {
                return ((JDBCType)next).getName();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            children.addAll(this.jdbcTypes);
        }
        collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            children.addAll(this.jdbcTypeToJavaTypeDeclarationMappings);
        }
        collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            children.addAll(this.javaTypeDeclarationToJDBCTypeMappings);
        }
    }

    private void checkJDBCType(JDBCType jdbcType) {
        this.checkJDBCType(jdbcType.getName(), jdbcType.getCode());
    }

    private void checkJDBCType(String jdbcTypeName, int jdbcTypeCode) {
        this.checkJDBCTypeName(jdbcTypeName);
        this.checkJDBCTypeCode(jdbcTypeCode);
    }

    void checkJDBCTypeName(String jdbcTypeName) {
        if (jdbcTypeName == null) {
            throw new NullPointerException();
        }
        if (CollectionTools.contains(this.jdbcTypeNames(), (Object)jdbcTypeName)) {
            throw new IllegalArgumentException("duplicate JDBC type name: " + jdbcTypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkJDBCTypeCode(int jdbcTypeCode) {
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            Iterator stream = this.jdbcTypes.iterator();
            while (stream.hasNext()) {
                if (((JDBCType)stream.next()).getCode() != jdbcTypeCode) continue;
                throw new IllegalArgumentException("duplicate JDBC type code: " + jdbcTypeCode);
            }
        }
    }

    private void checkJDBCToJavaMapping(JDBCType jdbcType) {
        if (this.jdbcTypeCanBeMappedToJavaTypeDeclaration(jdbcType)) {
            throw new IllegalArgumentException("duplicate mapping: " + jdbcType.getName());
        }
    }

    private void checkJavaToJDBCMapping(String javaClassName, int arrayDepth) {
        if (this.javaTypeDeclarationCanBeMappedToJDBCType(javaClassName, arrayDepth)) {
            throw new IllegalArgumentException("duplicate mapping: " + javaClassName + this.brackets(arrayDepth));
        }
    }

    private void checkJavaToJDBCMapping(JavaTypeDeclaration javaTypeDeclaration) {
        this.checkJavaToJDBCMapping(javaTypeDeclaration.getJavaClassName(), javaTypeDeclaration.getArrayDepth());
    }

    private void read(Node node) throws CorruptXMLException {
        if (node == null) {
            throw new CorruptXMLException("missing node");
        }
        this.readJDBCTypeNodes(XMLTools.child(node, "jdbc-types"));
        if (this.jdbcTypes.isEmpty()) {
            throw new CorruptXMLException("the JDBC type repository is empty");
        }
        String defaultJDBCTypeName = XMLTools.childTextContent(node, "default-jdbc-type", null);
        try {
            this.defaultJDBCType = this.jdbcTypeNamed(defaultJDBCTypeName);
        }
        catch (IllegalArgumentException ex) {
            throw new CorruptXMLException("default JDBC type", ex);
        }
        this.readJDBCToJavaMappingNodes(XMLTools.child(node, "jdbc-type-to-java-type-declaration-mappings"));
        if (this.jdbcTypeToJavaTypeDeclarationMappings.size() != this.jdbcTypes.size()) {
            throw new CorruptXMLException("all the JDBC types must be mapped to Java type declarations");
        }
        this.readJavaToJDBCMappingNodes(XMLTools.child(node, "java-type-declaration-to-jdbc-type-mappings"));
    }

    private void readJDBCTypeNodes(Node jdbcTypesNode) throws CorruptXMLException {
        Node[] jdbcTypeNodes = XMLTools.children(jdbcTypesNode, "jdbc-type");
        int len = jdbcTypeNodes.length;
        for (int i = 0; i < len; ++i) {
            JDBCType jdbcType = new JDBCType(this, jdbcTypeNodes[i]);
            try {
                this.checkJDBCType(jdbcType);
            }
            catch (IllegalArgumentException ex) {
                throw new CorruptXMLException(ex);
            }
            this.jdbcTypes.add(jdbcType);
        }
    }

    private void readJDBCToJavaMappingNodes(Node mappingsNode) throws CorruptXMLException {
        Node[] mappingNodes = XMLTools.children(mappingsNode, "jdbc-type-to-java-type-declaration-mapping");
        int len = mappingNodes.length;
        for (int i = 0; i < len; ++i) {
            JDBCTypeToJavaTypeDeclarationMapping mapping = new JDBCTypeToJavaTypeDeclarationMapping(this, mappingNodes[i]);
            try {
                this.checkJDBCToJavaMapping(mapping.getJDBCType());
            }
            catch (IllegalArgumentException ex) {
                throw new CorruptXMLException(ex);
            }
            this.jdbcTypeToJavaTypeDeclarationMappings.add(mapping);
        }
    }

    private void readJavaToJDBCMappingNodes(Node mappingsNode) throws CorruptXMLException {
        Node[] mappingNodes = XMLTools.children(mappingsNode, "java-type-declaration-to-jdbc-type-mapping");
        int len = mappingNodes.length;
        for (int i = 0; i < len; ++i) {
            JavaTypeDeclarationToJDBCTypeMapping mapping = new JavaTypeDeclarationToJDBCTypeMapping(this, mappingNodes[i]);
            try {
                this.checkJavaToJDBCMapping(mapping.getJavaTypeDeclaration());
            }
            catch (IllegalArgumentException ex) {
                throw new CorruptXMLException(ex);
            }
            this.javaTypeDeclarationToJDBCTypeMappings.add(mapping);
        }
    }

    void write(Node node) {
        Document document = node.getOwnerDocument();
        XMLTools.addSimpleTextNode(node, "default-jdbc-type", this.defaultJDBCType.getName());
        this.writeJDBCTypeNodes(node.appendChild(document.createElement("jdbc-types")));
        this.writeJDBCToJavaMappingNodes(node.appendChild(document.createElement("jdbc-type-to-java-type-declaration-mappings")));
        this.writeJavaToJDBCMappingNodes(node.appendChild(document.createElement("java-type-declaration-to-jdbc-type-mappings")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJDBCTypeNodes(Node jdbcTypesNode) {
        Document document = jdbcTypesNode.getOwnerDocument();
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            Iterator stream = new TreeSet(this.jdbcTypes).iterator();
            while (stream.hasNext()) {
                Element jdbcTypeNode = document.createElement("jdbc-type");
                jdbcTypesNode.appendChild(jdbcTypeNode);
                ((JDBCType)stream.next()).write(jdbcTypeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJDBCToJavaMappingNodes(Node mappingsNode) {
        Document document = mappingsNode.getOwnerDocument();
        Collection collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            Iterator stream = new TreeSet(this.jdbcTypeToJavaTypeDeclarationMappings).iterator();
            while (stream.hasNext()) {
                Element mappingNode = document.createElement("jdbc-type-to-java-type-declaration-mapping");
                mappingsNode.appendChild(mappingNode);
                ((JDBCTypeToJavaTypeDeclarationMapping)stream.next()).write(mappingNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavaToJDBCMappingNodes(Node mappingsNode) {
        Document document = mappingsNode.getOwnerDocument();
        Collection collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            Iterator stream = new TreeSet(this.javaTypeDeclarationToJDBCTypeMappings).iterator();
            while (stream.hasNext()) {
                Element mappingNode = document.createElement("java-type-declaration-to-jdbc-type-mapping");
                mappingsNode.appendChild(mappingNode);
                ((JavaTypeDeclarationToJDBCTypeMapping)stream.next()).write(mappingNode);
            }
        }
    }

    private String brackets(int arrayDepth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arrayDepth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @Override
    public String displayString() {
        return "";
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.jdbcTypes.size() + " JDBC types");
    }
}

