/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWRootEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMappingHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWAbstractReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class MWEisReferenceMapping
extends MWAbstractReferenceMapping
implements MWXmlMapping,
MWXmlReferenceMapping {
    private List xmlFieldPairs;
    public static final String XML_FIELD_PAIRS_LIST = "xmlFieldPairs";
    private volatile MWEisInteraction selectionInteraction;
    public static final String SELECTION_INTERACTION_PROPERTY = "selectionInteraction";
    private volatile boolean maintainsBidirectionalRelationship;
    public static final String MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY = "maintainsBidirectionalRelationship";
    private MWMappingHandle relationshipPartnerMappingHandle;
    public static final String RELATIONSHIP_PARTNER_MAPPING_PROPERTY = "relationshipPartnerMapping";

    protected MWEisReferenceMapping() {
    }

    protected MWEisReferenceMapping(MWMappingDescriptor descriptor, MWClassAttribute attribute, String attributeName) {
        super(descriptor, attribute, attributeName);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.xmlFieldPairs = new Vector();
        this.relationshipPartnerMappingHandle = new MWMappingHandle(this, this.buildRelationshipPartnerMappingScrubber());
        if (this.requiresSelectionInteraction()) {
            this.selectionInteraction = new MWEisInteraction(this);
        }
    }

    protected abstract boolean requiresSelectionInteraction();

    @Override
    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor descriptor) {
        return ((MWEisDescriptor)descriptor).isRootDescriptor();
    }

    @Override
    public int xmlFieldPairsSize() {
        return this.xmlFieldPairs.size();
    }

    public ListIterator xmlFieldPairs() {
        return new CloneListIterator(this.xmlFieldPairs);
    }

    @Override
    public MWXmlFieldPair xmlFieldPairAt(int index) {
        return (MWXmlFieldPair)this.xmlFieldPairs.get(index);
    }

    @Override
    public MWXmlFieldPair addFieldPair(String sourceXpath, String targetXpath) {
        MWXmlFieldPair xmlFieldPair = new MWXmlFieldPair(this, sourceXpath, targetXpath);
        this.addFieldPair(xmlFieldPair);
        return xmlFieldPair;
    }

    @Override
    public void addFieldPair(MWXmlFieldPair xmlFieldPair) {
        this.addItemToList(this.xmlFieldPairsSize(), xmlFieldPair, this.xmlFieldPairs, XML_FIELD_PAIRS_LIST);
    }

    @Override
    public MWXmlFieldPair buildEmptyFieldPair() {
        return new MWXmlFieldPair(this);
    }

    @Override
    public void removeXmlFieldPair(MWXmlFieldPair xmlFieldPair) {
        this.removeNodeFromList(this.xmlFieldPairs.indexOf(xmlFieldPair), this.xmlFieldPairs, XML_FIELD_PAIRS_LIST);
    }

    @Override
    public void clearXmlFieldPairs() {
        this.clearList(this.xmlFieldPairs, XML_FIELD_PAIRS_LIST);
    }

    @Override
    public boolean maintainsBidirectionalRelationship() {
        return this.maintainsBidirectionalRelationship;
    }

    public void setMaintainsBidirectionalRelationship(boolean maintainsBidirectionalRelationship) {
        boolean old = this.maintainsBidirectionalRelationship;
        this.maintainsBidirectionalRelationship = maintainsBidirectionalRelationship;
        this.firePropertyChanged(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, old, maintainsBidirectionalRelationship);
        if (!maintainsBidirectionalRelationship) {
            this.setRelationshipPartnerMapping(null);
        }
    }

    @Override
    public MWMapping getRelationshipPartnerMapping() {
        return this.relationshipPartnerMappingHandle.getMapping();
    }

    public void setRelationshipPartnerMapping(MWMapping relationshipPartnerMapping) {
        MWMapping old = this.relationshipPartnerMappingHandle.getMapping();
        this.relationshipPartnerMappingHandle.setMapping(relationshipPartnerMapping);
        this.firePropertyChanged(RELATIONSHIP_PARTNER_MAPPING_PROPERTY, old, relationshipPartnerMapping);
    }

    @Override
    public void setReferenceDescriptor(MWDescriptor newReferenceDescriptor) {
        if (this.getReferenceDescriptor() != newReferenceDescriptor) {
            this.setRelationshipPartnerMapping(null);
        }
        super.setReferenceDescriptor(newReferenceDescriptor);
    }

    @Override
    public boolean isValidRelationshipPartner() {
        return true;
    }

    public MWEisInteraction getSelectionInteraction() {
        return this.selectionInteraction;
    }

    protected void setSelectionInteraction(MWEisInteraction selectionInteraction) {
        if (this.requiresSelectionInteraction() && selectionInteraction == null) {
            throw new NullPointerException();
        }
        MWEisInteraction old = this.selectionInteraction;
        this.selectionInteraction = selectionInteraction;
        this.firePropertyChanged(SELECTION_INTERACTION_PROPERTY, old, selectionInteraction);
    }

    @Override
    public MWSchemaContextComponent schemaContext() {
        return this.eisDescriptor().getSchemaContext();
    }

    @Override
    public MWXmlField firstMappedXmlField() {
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            MWXmlField xmlField = ((MWXmlFieldPair)stream.next()).getSourceXmlField();
            if (!xmlField.isSpecified()) continue;
            return xmlField;
        }
        return null;
    }

    @Override
    public void addWrittenFieldsTo(Collection writtenXpaths) {
        if (this.isReadOnly()) {
            return;
        }
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            MWXmlField xmlField = ((MWXmlFieldPair)stream.next()).getSourceXmlField();
            if (!xmlField.isSpecified()) continue;
            writtenXpaths.add(xmlField);
        }
    }

    @Override
    public abstract boolean sourceFieldMayUseCollectionXpath();

    protected MWEisDescriptor eisDescriptor() {
        return (MWEisDescriptor)this.getParent();
    }

    protected MWEisDescriptor referenceEisDescriptor() {
        return this.getReferenceDescriptor() == null ? null : (MWEisDescriptor)this.getReferenceDescriptor();
    }

    protected MWRootEisDescriptor referenceRootEisDescriptor() {
        return this.referenceEisDescriptor() == null || !this.referenceEisDescriptor().isRootDescriptor() ? null : (MWRootEisDescriptor)this.referenceEisDescriptor();
    }

    @Override
    public MWEisDescriptor referenceDescriptor() {
        return this.getReferenceDescriptor() == null ? null : (MWEisDescriptor)this.getReferenceDescriptor();
    }

    @Override
    protected void initializeFromMWEisReferenceMapping(MWEisReferenceMapping oldMapping) {
        super.initializeFromMWEisReferenceMapping(oldMapping);
        ListIterator stream = oldMapping.xmlFieldPairs();
        while (stream.hasNext()) {
            MWXmlFieldPair fieldPair = (MWXmlFieldPair)stream.next();
            this.addFieldPair(fieldPair.getSourceXmlField().getXpath(), fieldPair.getTargetXmlField().getXpath());
        }
        this.setMaintainsBidirectionalRelationship(oldMapping.maintainsBidirectionalRelationship());
        this.setRelationshipPartnerMapping(oldMapping.getRelationshipPartnerMapping());
        MWEisInteraction interaction = oldMapping.getSelectionInteraction();
        if (this.requiresSelectionInteraction() && interaction == null) {
            this.setSelectionInteraction(new MWEisInteraction(this));
        } else {
            this.setSelectionInteraction(interaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List list = this.xmlFieldPairs;
        synchronized (list) {
            children.addAll(this.xmlFieldPairs);
        }
        children.add(this.relationshipPartnerMappingHandle);
        if (this.requiresSelectionInteraction()) {
            children.add(this.selectionInteraction);
        } else if (this.selectionInteraction != null) {
            children.add(this.selectionInteraction);
        }
    }

    private MWHandle.NodeReferenceScrubber buildRelationshipPartnerMappingScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWEisReferenceMapping.this.setRelationshipPartnerMapping(null);
            }

            public String toString() {
                return "MWEisReferenceMapping.buildRelationshipPartnerMappingScrubber()";
            }
        };
    }

    @Override
    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
        super.mappingReplaced(oldMapping, newMapping);
        if (oldMapping == this.getRelationshipPartnerMapping()) {
            this.setRelationshipPartnerMapping(newMapping);
        }
    }

    @Override
    public void resolveXpaths() {
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).resolveXpaths();
        }
    }

    @Override
    public void schemaChanged(SchemaChange change) {
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).schemaChanged(change);
        }
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkDuplicateSourceXpath(newProblems);
        this.checkDuplicateTargetXpath(newProblems);
        this.checkRelationshipPartner(newProblems);
    }

    @Override
    protected String referenceDescriptorInvalidProblemString() {
        return "0590";
    }

    private void checkDuplicateSourceXpath(List newProblems) {
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            Problem problem;
            String sourceXpath;
            MWXmlFieldPair fieldPair = (MWXmlFieldPair)stream.next();
            if (!fieldPair.duplicateSourceXpath(sourceXpath = fieldPair.getSourceXmlField().getXpath()) || newProblems.contains(problem = this.buildProblem("0596", sourceXpath))) continue;
            newProblems.add(problem);
        }
    }

    private void checkDuplicateTargetXpath(List newProblems) {
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            Problem problem;
            String targetXpath;
            MWXmlFieldPair fieldPair = (MWXmlFieldPair)stream.next();
            if (!fieldPair.duplicateTargetXpath(targetXpath = fieldPair.getTargetXmlField().getXpath()) || newProblems.contains(problem = this.buildProblem("0597", targetXpath))) continue;
            newProblems.add(problem);
        }
    }

    private void checkRelationshipPartner(List newProblems) {
        if (this.maintainsBidirectionalRelationship()) {
            MWMapping partnerMapping = this.getRelationshipPartnerMapping();
            if (partnerMapping == null) {
                newProblems.add(this.buildProblem("0591"));
            } else {
                if (!partnerMapping.isValidRelationshipPartner()) {
                    newProblems.add(this.buildProblem("0592"));
                }
                if (!partnerMapping.maintainsBidirectionalRelationship() || partnerMapping.getRelationshipPartnerMapping() != this) {
                    newProblems.add(this.buildProblem("0593"));
                }
            }
        }
    }

    public boolean duplicatedSourceXmlField(MWXmlField sourceXmlField) {
        if (sourceXmlField.isSpecified()) {
            ListIterator stream = this.xmlFieldPairs();
            while (stream.hasNext()) {
                MWXmlField nextSourceXmlField = ((MWXmlFieldPair)stream.next()).getSourceXmlField();
                if (sourceXmlField == nextSourceXmlField || !sourceXmlField.getXpath().equals(nextSourceXmlField.getXpath())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean duplicatedTargetXmlField(MWXmlField targetXmlField) {
        if (targetXmlField.isSpecified()) {
            ListIterator stream = this.xmlFieldPairs();
            while (stream.hasNext()) {
                MWXmlField nextTargetXmlField = ((MWXmlFieldPair)stream.next()).getTargetXmlField();
                if (targetXmlField == nextTargetXmlField || !targetXmlField.getXpath().equals(nextTargetXmlField.getXpath())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)super.runtimeMapping();
        if (this.maintainsBidirectionalRelationship() && this.getRelationshipPartnerMapping() != null) {
            mapping.setRelationshipPartnerAttributeName(this.getRelationshipPartnerMapping().getName());
        }
        MWEisInteraction interaction = this.getSelectionInteraction();
        if (this.requiresSelectionInteraction()) {
            mapping.setSelectionCall((Call)interaction.runtimeInteraction());
        } else if (interaction != null && interaction.isSpecified()) {
            mapping.setSelectionCall((Call)interaction.runtimeInteraction());
        }
        return mapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWEisReferenceMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractReferenceMapping.class);
        XMLCompositeCollectionMapping xpathFieldPairsListMapping = new XMLCompositeCollectionMapping();
        xpathFieldPairsListMapping.setAttributeName(XML_FIELD_PAIRS_LIST);
        xpathFieldPairsListMapping.setReferenceClass(MWXmlFieldPair.class);
        xpathFieldPairsListMapping.setXPath("xml-field-pairs/field-pair");
        descriptor.addMapping((DatabaseMapping)xpathFieldPairsListMapping);
        XMLDirectMapping mbdrMapping = (XMLDirectMapping)descriptor.addDirectMapping(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, "maintains-bidirectional-relationship/text()");
        mbdrMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping relationshipPartnerMapping = new XMLCompositeObjectMapping();
        relationshipPartnerMapping.setAttributeName("relationshipPartnerMappingHandle");
        relationshipPartnerMapping.setGetMethodName("getRelationshipPartnerMappingHandleForTopLink");
        relationshipPartnerMapping.setSetMethodName("setRelationshipPartnerMappingHandleForTopLink");
        relationshipPartnerMapping.setReferenceClass(MWMappingHandle.class);
        relationshipPartnerMapping.setXPath("relationship-partner-mapping-handle");
        descriptor.addMapping((DatabaseMapping)relationshipPartnerMapping);
        XMLCompositeObjectMapping selectionInteractionMapping = new XMLCompositeObjectMapping();
        selectionInteractionMapping.setAttributeName(SELECTION_INTERACTION_PROPERTY);
        selectionInteractionMapping.setReferenceClass(MWEisInteraction.class);
        selectionInteractionMapping.setXPath("selection-interaction");
        descriptor.addMapping((DatabaseMapping)selectionInteractionMapping);
        return descriptor;
    }

    private MWMappingHandle getRelationshipPartnerMappingHandleForTopLink() {
        return this.relationshipPartnerMappingHandle.getMapping() == null ? null : this.relationshipPartnerMappingHandle;
    }

    private void setRelationshipPartnerMappingHandleForTopLink(MWMappingHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildRelationshipPartnerMappingScrubber();
        this.relationshipPartnerMappingHandle = handle == null ? new MWMappingHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

