/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DecimalType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.UnresolvedTypesVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FunctionDDLTestSuite {
    static final String CREATE_FUNCTION_PREFIX = "CREATE FUNCTION ";
    static DDLParser parser = null;
    static final String EMPTY_FUNCTION = "EMPTY_FUNCTION";
    static final String CREATE_EMPTY_FUNCTION = "CREATE FUNCTION EMPTY_FUNCTION RETURN DECIMAL IS BEGIN RETURN 0; END";
    static final String SIMPLE_FUNCTION = "SIMPLE_FUNCTION";
    static final String SIMPLE_ARG = "DEPT";
    static final String CREATE_SIMPLE_FUNCTION = "CREATE FUNCTION SIMPLE_FUNCTION (DEPT IN DECIMAL) RETURN DECIMAL AS BEGIN SELECT max(SAL) INTO MAXSAL FROM SIMPLESF WHERE DEPTNO = DEPT; RETURN(MAXSAL); END";
    static final String FUNCTION_W_KEYWORDS = "KEYWORDSF";
    static final String IN_ARG1 = "OPERATOR";
    static final String IN_ARG2 = "ARRAY";
    static final String CREATE_FUNCTION_W_KEYWORDS = "CREATE FUNCTION KEYWORDSF ( OPERATOR IN VARCHAR2, ARRAY IN DATE) return Integer AS BEGIN return 1;END";

    @BeforeClass
    public static void setUp() {
        parser = new DDLParser(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        parser.setTypesRepository(new DatabaseTypesRepository());
    }

    @Test
    public void testEmptyFunction() {
        parser.ReInit(new StringReader(CREATE_EMPTY_FUNCTION));
        boolean worked = true;
        FunctionType functionType = null;
        try {
            functionType = parser.parseTopLevelFunction();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"empty function should parse", (boolean)worked);
        Assert.assertEquals((String)"empty function wrong name", (Object)functionType.getProcedureName(), (Object)EMPTY_FUNCTION);
        Assert.assertTrue((String)"empty function should have no arguments", (boolean)functionType.getArguments().isEmpty());
    }

    @Test
    public void testSimpleFunction() {
        parser.ReInit(new StringReader(CREATE_SIMPLE_FUNCTION));
        boolean worked = true;
        String message = "";
        FunctionType functionType = null;
        try {
            functionType = parser.parseTopLevelFunction();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("simple function did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(functionType);
        Assert.assertTrue((String)"simple function should not contain any unresolved datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"simple function wrong name", (Object)functionType.getProcedureName(), (Object)SIMPLE_FUNCTION);
        ArgumentType returnArg = functionType.getReturnArgument();
        Assert.assertEquals((String)"simple function should have DECIMAL return type", (Object)new DecimalType().getTypeName(), (Object)returnArg.getTypeName());
        Assert.assertTrue((String)"dummy procedure should have 1 argument", (functionType.getArguments().size() == 1 ? 1 : 0) != 0);
        ArgumentType arg1 = functionType.getArguments().get(0);
        Assert.assertEquals((String)"dummy procedure's argument wrong name", (Object)arg1.getArgumentName(), (Object)SIMPLE_ARG);
        DatabaseType arg1Type = arg1.getEnclosedType();
        Assert.assertEquals((String)("incorrect type for " + arg1.getArgumentName() + " type"), (Object)new DecimalType().getTypeName(), (Object)arg1Type.getTypeName());
        Assert.assertTrue((String)("incorrect direction for " + arg1.getArgumentName()), (arg1.getDirection() == ArgumentTypeDirection.IN ? 1 : 0) != 0);
    }

    @Test
    public void testFunction_With_Keyword() {
        parser.ReInit(new StringReader(CREATE_FUNCTION_W_KEYWORDS));
        boolean worked = true;
        String message = "";
        FunctionType functionType = null;
        try {
            functionType = parser.parseTopLevelFunction();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("function with keywords did not parse:\n" + message), (boolean)worked);
        Assert.assertEquals((String)"incorrect function name KEYWORDSF", (Object)FUNCTION_W_KEYWORDS, (Object)functionType.getProcedureName());
    }
}

