/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public abstract class ListCurator
extends AspectAdapter
implements ListValueModel {
    private List record;
    private StateChangeListener stateChangeListener;

    protected ListCurator(Model subject) {
        super(subject);
    }

    protected ListCurator(ValueModel subjectHolder) {
        super(subjectHolder);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.record = new ArrayList();
        this.stateChangeListener = this.buildStateChangeListener();
    }

    protected StateChangeListener buildStateChangeListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent e) {
                ListCurator.this.submitInventoryReport();
            }

            public String toString() {
                return "state change listener";
            }
        };
    }

    @Override
    public Object getValue() {
        return new ReadOnlyListIterator(this.record);
    }

    @Override
    public Object getItem(int index) {
        return this.record.get(index);
    }

    @Override
    public int size() {
        return this.record.size();
    }

    @Override
    public void addItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addItems(int index, List items) {
        for (int i = 0; i < items.size(); ++i) {
            this.addItem(index + i, items.get(i));
        }
    }

    @Override
    public Object removeItem(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List removeItems(int index, int length) {
        ArrayList<Object> removedItems = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            removedItems.add(this.removeItem(index));
        }
        return removedItems;
    }

    @Override
    public Object replaceItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List replaceItems(int index, List items) {
        ArrayList<Object> replacedItems = new ArrayList<Object>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            replacedItems.add(this.replaceItem(index + i, items.get(i)));
        }
        return replacedItems;
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("value");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireListChanged("value");
    }

    @Override
    protected void engageNonNullSubject() {
        ((Model)this.subject).addStateChangeListener(this.stateChangeListener);
        CollectionTools.addAll((Collection)this.record, (Iterator)this.getValueForRecord());
    }

    @Override
    protected void disengageNonNullSubject() {
        ((Model)this.subject).removeStateChangeListener(this.stateChangeListener);
        this.record.clear();
    }

    protected abstract Iterator getValueForRecord();

    void submitInventoryReport() {
        List newRecord = CollectionTools.list((Iterator)this.getValueForRecord());
        int recordIndex = 0;
        Iterator newItems = newRecord.iterator();
        while (newItems.hasNext()) {
            this.inventoryNewItem(recordIndex, newItems.next());
            ++recordIndex;
        }
        recordIndex = 0;
        while (recordIndex < this.record.size()) {
            Object item = this.record.get(recordIndex);
            if (!newRecord.contains(item)) {
                this.removeItemFromInventory(recordIndex, item);
                continue;
            }
            ++recordIndex;
        }
    }

    private void inventoryNewItem(int recordIndex, Object newItem) {
        ArrayList rec = new ArrayList(this.record);
        if (recordIndex < rec.size() && rec.get(recordIndex).equals(newItem)) {
            return;
        }
        if (!rec.contains(newItem)) {
            this.addItemToInventory(recordIndex, newItem);
        } else {
            this.removeItemFromInventory(recordIndex, rec.get(recordIndex));
            this.inventoryNewItem(recordIndex, newItem);
        }
    }

    private void addItemToInventory(int index, Object item) {
        this.record.add(index, item);
        this.fireItemAdded("value", index, item);
    }

    private void removeItemFromInventory(int index, Object item) {
        this.record.remove(item);
        this.fireItemRemoved("value", index, item);
    }
}

