/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class RenameDialog
extends AbstractValidatingDialog {
    private JTextField nameTextField;
    private final Collection sessionNames;
    private final PropertyValueModel stringHolder;

    public RenameDialog(WorkbenchContext context, PropertyValueModel stringHolder, Collection sessionNames) {
        super(context);
        this.stringHolder = stringHolder;
        this.sessionNames = sessionNames;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    private Document buildNameDocumentAdapter() {
        return new DocumentAdapter(this.stringHolder);
    }

    @Override
    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("RENAME_DIALOG_TITLE"));
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(this.resourceRepository().getString("SESSION_NAME_LABEL"));
        nameLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SESSION_NAME_LABEL"));
        nameLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("SESSION_NAME_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)nameLabel, constraints);
        this.nameTextField = new JTextField(this.buildNameDocumentAdapter(), null, 20);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.nameTextField, constraints);
        nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RenameDialog.this.updateOKAction();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RenameDialog.this.updateOKAction();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.helpManager().addTopicID(panel, this.helpTopicId() + ".name");
        return panel;
    }

    protected String getNewName() {
        return this.nameTextField.getText().trim();
    }

    private void updateOKAction() {
        String sessionName = this.nameTextField.getText().trim();
        boolean valid = sessionName.length() > 0 && !this.sessionNames.contains(sessionName);
        this.getOKAction().setEnabled(valid);
        if (valid) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("SESSION_CREATION_DIALOG_INVALID_NAME");
        }
    }

    @Override
    protected String helpTopicId() {
        return "dialog.renameSession";
    }

    @Override
    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.selectAll();
    }

    @Override
    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

