/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import javax.swing.Icon;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LoggingOptionsConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoggingOptionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;

public abstract class LogAdapter
extends SCAdapter {
    private volatile LoggingOptionsAdapter loggingOptions;
    public static final String LOG_OPTIONS_PROPERTY = "logOptions";
    public static final String SHOULD_LOG_EXCEPTION_STACK_TRACE_PROPERTY = "shouldLogExceptionStackTrace";
    public static final String SHOULD_PRINT_CONNECTION_PROPERTY = "shouldPrintConnection";
    public static final String SHOULD_PRINT_DATE_PROPERTY = "shouldPrintDate";
    public static final String SHOULD_PRINT_SESSION_PROPERTY = "shouldPrintSession";
    public static final String SHOULD_PRINT_THREAD_PROPERTY = "shouldPrintThread";

    LogAdapter(SCAdapter parent, LogConfig scConfig) {
        super(parent, scConfig);
    }

    protected LogAdapter(SCAdapter parent) {
        super(parent);
    }

    public Icon icon() {
        return null;
    }

    private final LogConfig logConfig() {
        return (LogConfig)this.getModel();
    }

    private LoggingOptionsAdapter buildLoggingOptions() {
        LoggingOptionsAdapter loggingOptions = new LoggingOptionsAdapter(this);
        this.logConfig().setLoggingOptions((LoggingOptionsConfig)loggingOptions.getModel());
        return loggingOptions;
    }

    private LoggingOptionsAdapter removeLoggingOptions() {
        this.logConfig().setLoggingOptions(null);
        return null;
    }

    private LoggingOptionsConfig getLoggingOptionsConfig() {
        return this.logConfig().getLoggingOptions();
    }

    private LoggingOptionsAdapter getLoggingOptions() {
        return this.loggingOptions;
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.loggingOptions = null;
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.loggingOptions = (LoggingOptionsAdapter)this.adapt(this.getLoggingOptionsConfig());
    }

    public boolean optionsIsEnable() {
        return this.loggingOptions != null;
    }

    public void enableOptions() {
        LoggingOptionsAdapter old = this.loggingOptions;
        this.loggingOptions = this.buildLoggingOptions();
        this.firePropertyChanged(LOG_OPTIONS_PROPERTY, (Object)old, (Object)this.loggingOptions);
    }

    public void disableOptions() {
        LoggingOptionsAdapter old = this.loggingOptions;
        this.loggingOptions = this.removeLoggingOptions();
        this.firePropertyChanged(LOG_OPTIONS_PROPERTY, (Object)old, (Object)this.loggingOptions);
    }

    public boolean getShouldLogExceptionStackTrace() {
        return this.getLoggingOptions().getShouldLogExceptionStackTrace();
    }

    public void setShouldLogExceptionStackTrace(boolean value) {
        boolean old = this.getLoggingOptions().getShouldLogExceptionStackTrace();
        this.getLoggingOptions().setShouldLogExceptionStackTrace(value);
        this.firePropertyChanged(SHOULD_LOG_EXCEPTION_STACK_TRACE_PROPERTY, old, value);
    }

    public boolean getShouldPrintConnection() {
        return this.getLoggingOptions().getShouldPrintConnection();
    }

    public void setShouldPrintConnection(boolean value) {
        boolean old = this.getLoggingOptions().getShouldPrintConnection();
        this.getLoggingOptions().setShouldPrintConnection(value);
        this.firePropertyChanged(SHOULD_PRINT_CONNECTION_PROPERTY, old, value);
    }

    public boolean getShouldPrintDate() {
        return this.getLoggingOptions().getShouldPrintDate();
    }

    public void setShouldPrintDate(boolean value) {
        boolean old = this.getLoggingOptions().getShouldPrintDate();
        this.getLoggingOptions().setShouldPrintDate(value);
        this.firePropertyChanged(SHOULD_PRINT_DATE_PROPERTY, old, value);
    }

    public boolean getShouldPrintSession() {
        return this.getLoggingOptions().getShouldPrintSession();
    }

    public void setShouldPrintSession(boolean value) {
        boolean old = this.getLoggingOptions().getShouldPrintSession();
        this.getLoggingOptions().setShouldPrintSession(value);
        this.firePropertyChanged(SHOULD_PRINT_SESSION_PROPERTY, old, value);
    }

    public boolean getShouldPrintThread() {
        return this.getLoggingOptions().getShouldPrintThread();
    }

    public void setShouldPrintThread(boolean value) {
        boolean old = this.getLoggingOptions().getShouldPrintThread();
        this.getLoggingOptions().setShouldPrintThread(value);
        this.firePropertyChanged(SHOULD_PRINT_THREAD_PROPERTY, old, value);
    }
}

