/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.XpathChooserDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class XpathChooser
extends AbstractPanel {
    private ValueModel xmlFieldHolder;
    private PropertyValueModel xpathHolder;
    private Accessible labeler;

    public XpathChooser(WorkbenchContextHolder contextHolder, ValueModel xmlFieldHolder) {
        super(contextHolder);
        this.initialize(xmlFieldHolder);
    }

    public XpathChooser(WorkbenchContextHolder contextHolder, ValueModel xmlFieldHolder, PropertyValueModel xpathHolder) {
        super(contextHolder);
        this.initialize(xmlFieldHolder, xpathHolder);
    }

    private void initialize(ValueModel xmlFieldHolder) {
        this.initialize(xmlFieldHolder, this.buildXpathHolder(xmlFieldHolder));
    }

    private void initialize(ValueModel xmlFieldHolder, PropertyValueModel xpathHolder) {
        this.xmlFieldHolder = xmlFieldHolder;
        this.xpathHolder = xpathHolder;
        this.initializeLayout();
    }

    private PropertyValueModel buildXpathHolder(ValueModel xmlFieldHolder) {
        return new PropertyAspectAdapter(xmlFieldHolder, "xpath"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWXmlField)this.subject).getXpath();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWXmlField)this.subject).setXpath((String)value);
            }
        };
    }

    private void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JTextField textField = this.buildTextField();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)textField, constraints);
        JButton browseButton = this.buildButton();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)browseButton, constraints);
        this.addAlignRight(browseButton);
    }

    private JTextField buildTextField() {
        JTextField textField = new JTextField();
        textField.setDocument(this.buildXpathDocument());
        return textField;
    }

    private DocumentAdapter buildXpathDocument() {
        return new DocumentAdapter(this.xpathHolder);
    }

    private JButton buildButton() {
        JButton button = this.buildBrowseButton("BROWSE_BUTTON_1", this.buildLabeler());
        button.addActionListener(this.buildBrowseAction());
        return button;
    }

    private Accessible buildLabeler() {
        return new Accessible(){

            @Override
            public AccessibleContext getAccessibleContext() {
                if (XpathChooser.this.labeler != null) {
                    return XpathChooser.this.labeler.getAccessibleContext();
                }
                return null;
            }
        };
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                XpathChooser.this.promptToSelectXpath();
            }
        };
    }

    public void setAccessibleLabeler(Accessible labeler) {
        this.labeler = labeler;
        for (int i = this.getComponentCount(); i > 0; --i) {
            JComponent component = (JComponent)this.getComponent(i - 1);
            component.putClientProperty("labeledBy", labeler);
        }
    }

    private void promptToSelectXpath() {
        XpathChooserDialog.promptToSelectXpath(this.xmlFieldHolder, this.xpathHolder, this.getWorkbenchContext());
    }

    private MWXmlField xmlField() {
        return (MWXmlField)this.xmlFieldHolder.getValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            this.getComponent(i).setEnabled(enabled);
        }
    }
}

